--VBECS 2.2.0.1 and VBECS 2.2.0.2 Database Sustainment and S&Q Changes

USE @DBNAME@
GO


if exists (select * from dbo.sysobjects where id = object_id(N'dbo.PendingTestStatus') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.PendingTestStatus
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[PendingTestStatus](
	[PendingTestStatusId] [tinyint] NOT NULL,
	[PendingTestStatusText] [varchar](50) NOT NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
 CONSTRAINT [PK_PendingTestStatus] PRIMARY KEY CLUSTERED 
(
	[PendingTestStatusId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[PendingTestStatus] ADD  CONSTRAINT [DF_PendingTestStatus_LastUpdateFunctionId]  DEFAULT ((0)) FOR [LastUpdateFunctionId]
GO


EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The current state of the pending test result.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingTestStatus', @level2type=N'COLUMN',@level2name=N'PendingTestStatusId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Describes the testing status code.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingTestStatus', @level2type=N'COLUMN',@level2name=N'PendingTestStatusText'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date the associated record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingTestStatus', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The LogonId of the user who made the last update to the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingTestStatus', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingTestStatus', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingTestStatus', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO


if exists (select * from dbo.sysobjects where id = object_id(N'dbo.PendingBloodUnitTest') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.PendingBloodUnitTest
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[PendingBloodUnitTest](
	[PendingBloodUnitTestId] [int] IDENTITY(1, 1) NOT NULL,
	[BloodUnitTestGuid] [uniqueidentifier] NULL,
	[BloodUnitGuid] [uniqueidentifier] NULL,
	[BloodTestTypeId] [int] NOT NULL,
	[BloodUnitId] [varchar](13) NOT NULL,
	[TestDate] [datetime] NOT NULL,
	[TestTechId] [varchar](30) NOT NULL,
	[TestResultId] [char](3) NOT NULL,
	[AutoInstrumentComments] [varchar](510) NULL,
	[OrderedTestGuid] [uniqueidentifier] NULL,
	[OrderedComponentGuid] [uniqueidentifier] NULL,
	[AutoInstrumentName] [varchar](50) NOT NULL,
	[DivisionCode] [char](5) NOT NULL,
	[PendingTestStatusId] [tinyint] NOT NULL,
	[RejectionComment] [varchar] (510) NULL,
	[UnitResultSetGuid] [uniqueidentifier] NOT NULL,
	[OrderedUnitGuid] [uniqueidentifier] NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
 CONSTRAINT [PK_PendingBloodUnitTest] PRIMARY KEY NONCLUSTERED 
(
	[PendingBloodUnitTestId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] ADD  CONSTRAINT [DF_PendingBloodUnitTest_LastUpdateFunctionId]  DEFAULT ((0)) FOR [LastUpdateFunctionId]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_BloodTestType] FOREIGN KEY([BloodTestTypeId])
REFERENCES [dbo].[BloodTestType] ([BloodTestTypeId])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_BloodTestType]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_BloodUnit] FOREIGN KEY([BloodUnitGuid])
REFERENCES [dbo].[BloodUnit] ([BloodUnitGuid])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_BloodUnit]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_OrderedComponent] FOREIGN KEY([OrderedComponentGuid])
REFERENCES [dbo].[OrderedComponent] ([OrderedComponentGuid])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_OrderedComponent]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_OrderedTest] FOREIGN KEY([OrderedTestGuid])
REFERENCES [dbo].[OrderedTest] ([OrderedTestGuid])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_OrderedTest]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH CHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_PendingTestStatus] FOREIGN KEY([PendingTestStatusId])
REFERENCES [dbo].[PendingTestStatus] ([PendingTestStatusId])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_PendingTestStatus]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_TestResult] FOREIGN KEY([TestResultId])
REFERENCES [dbo].[TestResult] ([TestResultId])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_TestResult]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_BloodUnitTest] FOREIGN KEY([BloodUnitTestGuid])
REFERENCES [dbo].[BloodUnitTest] ([BloodUnitTestGuid])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_BloodUnitTest]
GO

ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_OrderedUnit] FOREIGN KEY([OrderedUnitGuid])
REFERENCES [dbo].[OrderedUnit] ([OrderedUnitGuid])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_OrderedUnit]
GO

CREATE CLUSTERED INDEX [IX_PendingBloodUnitTest_PendingTestStatusId_DivisionCode] ON [dbo].[PendingBloodUnitTest] ([PendingTestStatusId], [DivisionCode]) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies one test result for a specific blood unit.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'PendingBloodUnitTestId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies one test result for a specific blood unit.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'BloodUnitTestGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific unit of blood.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'BloodUnitGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific blood test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'BloodTestTypeId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The unit identifier from the label of a unit of blood.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'BloodUnitId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date of the associated test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'TestDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the technologist who performed the test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'TestTechId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The result of a test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'TestResultId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Observations of the test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'AutoInstrumentComments'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an individual request for a diagnostic test on a specimen for a patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'OrderedTestGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an order for a blood component for a patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'OrderedComponentGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the Automated Instrument name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'AutoInstrumentName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the division in which the test took place.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'DivisionCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The current state of the pending test result.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'PendingTestStatusId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Observations of the rejected test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'RejectionComment'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This uniquely identifies the Blood Unit results from a single message sent.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'UnitResultSetGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific instance of a unit of blood being associated with a specific order.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'OrderedUnitGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date the associated record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The LogonId of the user who made the last update to the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingBloodUnitTest', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.PendingSpecimenTest') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.PendingSpecimenTest
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[PendingSpecimenTest](
	[PendingSpecimenTestId] [int] IDENTITY(1, 1) NOT NULL,
	[SpecimenTestGuid] [uniqueidentifier] NULL,
	[OrderedTestGuid] [uniqueidentifier] NOT NULL,
	[PatientSpecimenGuid] [uniqueidentifier] NOT NULL,
	[BloodTestTypeId] [int] NOT NULL,
	[TestDate] [datetime] NOT NULL,
	[TestTechId] [varchar](30) NOT NULL,
	[TestResultId] [char](3) NOT NULL,
	[AutoInstrumentName] [varchar](50) NOT NULL,
	[AutoInstrumentComments] [varchar](510) NULL,
	[DivisionCode] [char](5) NOT NULL,
	[PendingTestStatusId] [tinyint] NOT NULL,
	[RejectionComment] [varchar] (510) NULL,
	[SpecimenResultSetGuid] [uniqueidentifier] NOT NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
 CONSTRAINT [PK_PendingSpecimenTest] PRIMARY KEY NONCLUSTERED 
(
	[PendingSpecimenTestId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[PendingSpecimenTest] ADD  CONSTRAINT [DF_PendingSpecimenTest_LastUpdateFunctionId]  DEFAULT ((0)) FOR [LastUpdateFunctionId]
GO

ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_BloodTestType] FOREIGN KEY([BloodTestTypeId])
REFERENCES [dbo].[BloodTestType] ([BloodTestTypeId])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_BloodTestType]
GO

ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_OrderedTest] FOREIGN KEY([OrderedTestGuid])
REFERENCES [dbo].[OrderedTest] ([OrderedTestGuid])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_OrderedTest]
GO

ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_PatientSpecimen] FOREIGN KEY([PatientSpecimenGuid])
REFERENCES [dbo].[PatientSpecimen] ([PatientSpecimenGuid])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_PatientSpecimen]
GO

ALTER TABLE [dbo].[PendingSpecimenTest]  WITH CHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_PendingTestStatus] FOREIGN KEY([PendingTestStatusId])
REFERENCES [dbo].[PendingTestStatus] ([PendingTestStatusId])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_PendingTestStatus]
GO

ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_TestResult] FOREIGN KEY([TestResultId])
REFERENCES [dbo].[TestResult] ([TestResultId])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_TestResult]
GO

ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_VamcDivision]
GO


ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_SpecimenTest] FOREIGN KEY([SpecimenTestGuid])
REFERENCES [dbo].[SpecimenTest] ([SpecimenTestGuid])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_SpecimenTest]
GO

CREATE CLUSTERED INDEX [IX_PendingSpecimenTest_PendingTestStatusId_DivisionCode] ON [dbo].[PendingSpecimenTest] ([PendingTestStatusId], [DivisionCode]) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific specimen test' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'PendingSpecimenTestId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a previously administered blood test for a patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'SpecimenTestGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an individual request for a diagnostic test on a specimen for a patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'OrderedTestGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier for a patient specimen.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'PatientSpecimenGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'BloodTestTypeId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date of the associated test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'TestDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the technologist who performed the test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'TestTechId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The result of a test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'TestResultId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the Automated Instrument name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'AutoInstrumentName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Observations of the test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'AutoInstrumentComments'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the division in which the test took place.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'DivisionCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The current state of the pending test result.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'PendingTestStatusId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Observations of the rejected test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'RejectionComment'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This uniquely identifies the Specimen Test results from a single message sent.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'SpecimenResultSetGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PendingSpecimenTest', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO


if exists (select * from dbo.sysobjects where id = object_id(N'dbo.BloodTestTypeMapping') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.BloodTestTypeMapping
GO

CREATE TABLE [dbo].[BloodTestTypeMapping](
	[BloodTestTypeMappingId] [int] NOT NULL,
	[BloodTestTypeId] [int] NOT NULL,
	[BloodPanelName] [varchar](35) NOT NULL,
	[BloodTestName] [varchar](35) NOT NULL,
	[AntigenTestTypeId] [int] NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
 CONSTRAINT [PK_BloodTestTypeMapping] PRIMARY KEY NONCLUSTERED 
(
	[BloodTestTypeMappingId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[BloodTestTypeMapping]  WITH NOCHECK ADD  CONSTRAINT [FK_BloodTestTypeMapping_BloodTestType] FOREIGN KEY([BloodTestTypeId])
REFERENCES [dbo].[BloodTestType] ([BloodTestTypeId])
GO

ALTER TABLE [dbo].[BloodTestTypeMapping] CHECK CONSTRAINT [FK_BloodTestTypeMapping_BloodTestType]
GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a Blood Test Type Mapping.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'BloodTestTypeMappingId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'BloodTestTypeId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the Blood Panel name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'BloodPanelName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the blood test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'BloodTestName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific antigen test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'AntigenTestTypeId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BloodTestTypeMapping', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO

CREATE CLUSTERED INDEX [IX_BloodTestTypeMapping_BloodPanelName_BloodTestName] ON [dbo].[BloodTestTypeMapping] ([BloodPanelName], [BloodTestName]) ON [PRIMARY]
GO

--Create Synonyms
CREATE SYNONYM [dbo].[SynMirror_PendingBloodUnitTest] FOR [@DBNAME@_MIRROR].[dbo].[PendingBloodUnitTest]
GO


CREATE SYNONYM [dbo].[SynMirror_PendingSpecimenTest] FOR [@DBNAME@_MIRROR].[dbo].[PendingSpecimenTest]
GO


/*****************************************************************************************
  VbecsLock table
*****************************************************************************************/

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VBECSLock_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsLock]'))
ALTER TABLE [dbo].[VbecsLock] DROP CONSTRAINT [FK_VBECSLock_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VBECSLock_VBECSLockFunction]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsLock]'))
ALTER TABLE [dbo].[VbecsLock] DROP CONSTRAINT [FK_VBECSLock_VBECSLockFunction]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[VbecsLock]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[VbecsLock]
GO

/****** Object:  Table [dbo].[VbecsLock]    Script Date: 1/22/2016 7:52:46 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[VbecsLock](
	[VbecsLockId] [int] IDENTITY(1, 1) NOT NULL,
	[LockedRecordGuid] [uniqueidentifier] NULL,
	[LockedUseCaseId] [int] NULL,
	[LockedFormId] [int] NOT NULL,
	[BaseLockedFormId] [int] NOT NULL,
	[LockFunctionId] [int] NOT NULL,
	[SessionGuid] [uniqueidentifier] NOT NULL,
	[DivisionCode] [char](5) NULL,
	[MultiDivisionIndicator] [bit] NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL CONSTRAINT [DF_VBECSLock_LastUpdateFunctionId]  DEFAULT ((0)),
 CONSTRAINT [PK_VBECSLock] PRIMARY KEY NONCLUSTERED 
(
	[VbecsLockId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[VbecsLock]  WITH CHECK ADD  CONSTRAINT [FK_VBECSLock_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[VbecsLock] CHECK CONSTRAINT [FK_VBECSLock_VamcDivision]
GO

ALTER TABLE [dbo].[VbecsLock]  WITH CHECK ADD  CONSTRAINT [FK_VBECSLock_VBECSLockFunction] FOREIGN KEY([LockFunctionId])
REFERENCES [dbo].[VbecsLockFunction] ([VbecsFunctionId])
GO

ALTER TABLE [dbo].[VbecsLock] CHECK CONSTRAINT [FK_VBECSLock_VBECSLockFunction]
GO

-- Constraints and Indexes

CREATE NONCLUSTERED INDEX [IX_VbecsLock_LastupdateUser] ON [dbo].[VbecsLock] ([LastUpdateUser]) INCLUDE ([DivisionCode], [LockedRecordGuid], [LockedUseCaseId], [SessionGuid]) ON [PRIMARY]
GO

CREATE CLUSTERED INDEX [IX_VbecsLock_LockedRecordGuid] ON [dbo].[VbecsLock] ([LockedRecordGuid]) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique ID of the VBECSLock table record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'VbecsLockId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Guid of the record lock (e.g. BloodUnitGuid, PatientGuid). Can be null if LockedUseCase is supplied.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LockedRecordGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Some UCs are not record specific and are completly locked when in use. Can be null when LockedRecordGuid is supplied.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LockedUseCaseId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique ID of the VBECS form. Ties to VbecsBaseForm.FormID property.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LockedFormId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to LockedFormId. Bottom-most FormId where lock-chain was created. Used to bubble-up timeout events to all chained forms.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'BaseLockedFormId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the function having the lock activated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LockFunctionId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'To differentiate locks between sessions, so that shutting down one instance of VBECS does not wipe out the locks for all sessions. Ties to Common.LogonUser.VbecsSessionGuid property.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'SessionGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the division in which the lock was created. Non division specific locks insert null.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'DivisionCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates that the lock affects multiple divisions (e.g. Interface record locks)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'MultiDivisionIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsLock', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO



--Permissions

GRANT SELECT ON  [dbo].[PendingBloodUnitTest] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[PendingSpecimenTest] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[PendingTestStatus] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[BloodTestTypeMapping] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[VbecsLock] TO [VbecsAppUser]
GO



-- Add 1 row to dbo.Interface
SET IDENTITY_INSERT dbo.Interface ON
INSERT INTO dbo.Interface (InterfaceId, InterfaceName, FieldSeparator, EncodingCharacters, InterfaceApplicationId, VbecsApplicationId, VersionId, 
ApplicationAckType, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES (5, N'Auto_Instrument', N'|', N'^~\&', N'IM', N'VBECS', N'2.4', N'AL', '2015-11-02 00:00:00.000', N'DNS   kozlod', 0)
SET IDENTITY_INSERT dbo.Interface OFF

-- Add 1 row to dbo.InterfaceControl
INSERT INTO dbo.InterfaceControl (InterfaceControlId, InterfaceId, InterfaceFacilityId, InterfacePortNumber, InterfaceIPAddress, InterfaceDomainName, VbecsFacilityId, ProcessingId, 
VbecsPortNumber, VbecsIPAddress, AckTimeout, ReTransmitAttempts, InterfaceAdministratorName, PurgeSuccessfulMessage, PurgeUnSuccessfulMessage, LogEventsIndicator, InterfaceActiveIndicator, 
LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) 
SELECT 5, 5, NULL, NULL, NULL, NULL, NULL, ProcessingId, NULL, NULL, 10, 5, N'Enter valid email address', 7, 7, 0, 0, getutcdate(), N'VBECS', 0
FROM dbo.InterfaceControl WHERE InterfaceId=1


-- Add data to the dbo.PendingTestStatus
INSERT INTO [dbo].[PendingTestStatus] ([PendingTestStatusId], [PendingTestStatusText], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (1, 'Pending', '2015-12-11 00:00:00.000', 'DNS   forstd', 0)
INSERT INTO [dbo].[PendingTestStatus] ([PendingTestStatusId], [PendingTestStatusText], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (2, 'Accepted', '2015-12-11 00:00:00.000', 'DNS   forstd', 0)
INSERT INTO [dbo].[PendingTestStatus] ([PendingTestStatusId], [PendingTestStatusText], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (3, 'Rejected', '2015-12-11 00:00:00.000', 'DNS   forstd', 0)

-- Add rows to [dbo].[VbecsLockFunction]
INSERT INTO [dbo].[VbecsLockFunction] ([VbecsFunctionId], [FunctionName], [FunctionDescription], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (114, 'UC114AutomatedTestingParser', 'Automated Testing Parser', '2016-01-21 00:00:00.000', 'DNS   LOHSEG0', 0)
INSERT INTO [dbo].[VbecsLockFunction] ([VbecsFunctionId], [FunctionName], [FunctionDescription], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (115, 'UC115AutomatedTestingReview', 'Automated Testing Review', '2016-02-02 00:00:00.000', 'DNS   LOHSEG0', 0)
-- Operation applied to 2 rows out of 2

-- Add rows to [dbo].[BloodTestType]
INSERT INTO [dbo].[BloodTestType] ([BloodTestTypeId], [BloodTestName], [OrderableTestId], [TestedWith], [Phase], [ReportableTestId], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (2139, 'ISInterp', NULL, NULL, NULL, NULL, 1, '2016-02-03 14:19:43.350', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestType] ([BloodTestTypeId], [BloodTestName], [OrderableTestId], [TestedWith], [Phase], [ReportableTestId], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (2140, 'AHGInterp', NULL, NULL, NULL, NULL, 2, '2016-02-03 14:20:07.080', 'DNS   DOBRAK', 0)
-- Operation applied to 2 rows out of 2


-- Add rows to [dbo].[BloodTestTypeMapping]
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (1, 52, 'ABS', 'ABSInterp', NULL, '2016-01-26 09:51:04.293', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (2, 152, 'ABS', 'ABSInterp', NULL, '2016-01-26 09:52:40.500', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (3, 34, 'ABS', 'SC1', NULL, '2016-01-26 09:47:54.080', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (4, 134, 'ABS', 'SC1', NULL, '2016-01-26 09:54:00.413', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (5, 38, 'ABS', 'SC2', NULL, '2016-01-26 09:48:26.700', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (6, 138, 'ABS', 'SC2', NULL, '2016-01-26 09:53:45.543', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (7, 42, 'ABS', 'SC3', NULL, '2016-01-26 09:49:26.440', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (8, 142, 'ABS', 'SC3', NULL, '2016-01-26 09:53:30.343', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (9, 46, 'ABS', 'SC4', NULL, '2016-01-26 09:49:47.777', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (10, 146, 'ABS', 'SC4', NULL, '2016-01-26 09:53:17.363', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (11, 50, 'ABS', 'SC5', NULL, '2016-01-26 09:50:30.220', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (12, 150, 'ABS', 'SC5', NULL, '2016-01-26 09:53:01.880', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (13, 441, 'Antigen Typing', 'AntiA1', 446, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (14, 841, 'Antigen Typing', 'AntiA1', 846, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (15, 1085, 'Antigen Typing', 'AntiAu(a)', 1090, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (16, 2085, 'Antigen Typing', 'AntiAu(a)', 2090, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (17, 1091, 'Antigen Typing', 'AntiAu(b)', 1096, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (18, 2091, 'Antigen Typing', 'AntiAu(b)', 2096, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (19, 207, 'Antigen Typing', 'AntiC', 212, '2016-01-14 08:06:22.163', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (20, 219, 'Antigen Typing', 'Antic', 224, '2016-01-14 08:07:18.097', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (21, 607, 'Antigen Typing', 'AntiC', 612, '2016-01-27 10:09:49.650', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (22, 619, 'Antigen Typing', 'Antic', 624, '2016-01-27 10:09:49.657', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (23, 405, 'Antigen Typing', 'AntiC(w)', 410, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (24, 805, 'Antigen Typing', 'AntiC(w)', 810, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (25, 1007, 'Antigen Typing', 'AntiC(x)', 1012, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (26, 2007, 'Antigen Typing', 'AntiC(x)', 2012, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (27, 1097, 'Antigen Typing', 'AntiCh', 1102, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (28, 2097, 'Antigen Typing', 'AntiCh', 2102, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (29, 1055, 'Antigen Typing', 'AntiCo(a)', 1060, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (30, 2055, 'Antigen Typing', 'AntiCo(a)', 2060, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (31, 1061, 'Antigen Typing', 'AntiCo(b)', 1066, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (32, 2061, 'Antigen Typing', 'AntiCo(b)', 2066, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (33, 1109, 'Antigen Typing', 'AntiCs(a)', 1114, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (34, 2109, 'Antigen Typing', 'AntiCs(a)', 2114, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (35, 459, 'Antigen Typing', 'AntiDi(a)', 464, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (36, 859, 'Antigen Typing', 'AntiDi(a)', 864, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (37, 465, 'Antigen Typing', 'AntiDi(b)', 470, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (38, 865, 'Antigen Typing', 'AntiDi(b)', 870, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (39, 1043, 'Antigen Typing', 'AntiDo(a)', 1048, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (40, 2043, 'Antigen Typing', 'AntiDo(a)', 2048, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (41, 1049, 'Antigen Typing', 'AntiDo(b)', 1054, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (42, 2049, 'Antigen Typing', 'AntiDo(b)', 2054, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (43, 213, 'Antigen Typing', 'AntiE', 218, '2016-01-14 08:07:54.190', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (44, 225, 'Antigen Typing', 'Antie', 230, '2016-01-14 08:08:37.047', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (45, 613, 'Antigen Typing', 'AntiE', 618, '2016-01-27 10:09:49.653', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (46, 625, 'Antigen Typing', 'Antie', 630, '2016-01-27 10:09:49.657', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (47, 1013, 'Antigen Typing', 'AntiE(w)', 1018, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (48, 2013, 'Antigen Typing', 'AntiE(w)', 2018, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (49, 303, 'Antigen Typing', 'AntiFy(a)', 308, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (50, 703, 'Antigen Typing', 'AntiFy(a)', 708, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (51, 309, 'Antigen Typing', 'AntiFy(b)', 314, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (52, 709, 'Antigen Typing', 'AntiFy(b)', 714, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (53, 1037, 'Antigen Typing', 'AntiH', 1042, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (54, 2037, 'Antigen Typing', 'AntiH', 2042, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (55, 279, 'Antigen Typing', 'AntiJk(a)', 284, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (56, 679, 'Antigen Typing', 'AntiJk(a)', 684, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (57, 285, 'Antigen Typing', 'AntiJk(b)', 290, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (58, 685, 'Antigen Typing', 'AntiJk(b)', 690, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (59, 1133, 'Antigen Typing', 'AntiJMH', 1138, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (60, 2133, 'Antigen Typing', 'AntiJMH', 2138, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (61, 369, 'Antigen Typing', 'AntiJs(a)', 374, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (62, 769, 'Antigen Typing', 'AntiJs(a)', 774, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (63, 375, 'Antigen Typing', 'AntiJs(b)', 380, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (64, 775, 'Antigen Typing', 'AntiJs(b)', 780, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (65, 255, 'Antigen Typing', 'AntiK', 260, '2016-01-14 08:09:30.627', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (66, 655, 'Antigen Typing', 'AntiK', 660, '2016-01-27 10:09:49.660', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (67, 261, 'Antigen Typing', 'Antik', 266, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (68, 661, 'Antigen Typing', 'Antik', 666, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (69, 1121, 'Antigen Typing', 'AntiKn(a)', 1126, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (70, 2121, 'Antigen Typing', 'AntiKn(a)', 2126, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (71, 267, 'Antigen Typing', 'AntiKp(a)', 272, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (72, 667, 'Antigen Typing', 'AntiKp(a)', 672, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (73, 273, 'Antigen Typing', 'AntiKp(b)', 278, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (74, 673, 'Antigen Typing', 'AntiKp(b)', 678, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (75, 357, 'Antigen Typing', 'AntiLe(a)', 362, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (76, 757, 'Antigen Typing', 'AntiLe(a)', 762, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (77, 363, 'Antigen Typing', 'AntiLe(b)', 368, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (78, 763, 'Antigen Typing', 'AntiLe(b)', 768, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (79, 381, 'Antigen Typing', 'AntiLu(a)', 386, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (80, 781, 'Antigen Typing', 'AntiLu(a)', 786, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (81, 387, 'Antigen Typing', 'AntiLu(b)', 392, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (82, 787, 'Antigen Typing', 'AntiLu(b)', 792, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (83, 1067, 'Antigen Typing', 'AntiLW(a)', 1072, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (84, 2067, 'Antigen Typing', 'AntiLW(a)', 2072, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (85, 1073, 'Antigen Typing', 'AntiLW(b)', 1078, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (86, 2073, 'Antigen Typing', 'AntiLW(b)', 2078, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (87, 315, 'Antigen Typing', 'AntiM', 320, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (88, 715, 'Antigen Typing', 'AntiM', 720, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (89, 1025, 'Antigen Typing', 'AntiM(g)', 1030, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (90, 2025, 'Antigen Typing', 'AntiM(g)', 2030, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (91, 1127, 'Antigen Typing', 'AntiMcC(a)', 1132, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (92, 2127, 'Antigen Typing', 'AntiMcC(a)', 2132, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (93, 1031, 'Antigen Typing', 'AntiMi(a)', 1036, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (94, 2031, 'Antigen Typing', 'AntiMi(a)', 2036, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (95, 321, 'Antigen Typing', 'AntiN', 326, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (96, 721, 'Antigen Typing', 'AntiN', 726, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (97, 429, 'Antigen Typing', 'AntiP', 434, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (98, 829, 'Antigen Typing', 'AntiP', 834, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (99, 345, 'Antigen Typing', 'AntiP1', 350, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (100, 745, 'Antigen Typing', 'AntiP1', 750, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (101, 1103, 'Antigen Typing', 'AntiRg', 1108, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (102, 2103, 'Antigen Typing', 'AntiRg', 2108, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (103, 327, 'Antigen Typing', 'AntiS', 332, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (104, 727, 'Antigen Typing', 'AntiS', 732, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (105, 333, 'Antigen Typing', 'Antis', 338, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (106, 733, 'Antigen Typing', 'Antis', 738, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (107, 477, 'Antigen Typing', 'AntiSc1', 482, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (108, 877, 'Antigen Typing', 'AntiSc1', 882, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (109, 483, 'Antigen Typing', 'AntiSc2', 488, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (110, 883, 'Antigen Typing', 'AntiSc2', 888, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (111, 1079, 'Antigen Typing', 'AntiSd(a)', 1084, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (112, 2079, 'Antigen Typing', 'AntiSd(a)', 2084, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (113, 339, 'Antigen Typing', 'AntiU', 344, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (114, 739, 'Antigen Typing', 'AntiU', 744, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (115, 1019, 'Antigen Typing', 'AntiV', 1024, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (116, 2019, 'Antigen Typing', 'AntiV', 2024, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (117, 423, 'Antigen Typing', 'AntiXg(a)', 428, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (118, 823, 'Antigen Typing', 'AntiXg(a)', 828, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (119, 1115, 'Antigen Typing', 'AntiYk(a)', 1120, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (120, 2115, 'Antigen Typing', 'AntiYk(a)', 2120, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (121, 489, 'Antigen Typing', 'AntiYt(a)', 494, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (122, 889, 'Antigen Typing', 'AntiYt(a)', 894, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (123, 495, 'Antigen Typing', 'AntiYt(b)', 500, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (124, 895, 'Antigen Typing', 'AntiYt(b)', 900, '2016-02-07 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (125, 53, 'DAT', 'AHG', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (126, 153, 'DAT', 'AHG', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (127, 59, 'DAT', 'Comp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (128, 159, 'DAT', 'Comp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (129, 61, 'DAT', 'CompInterp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (130, 161, 'DAT', 'CompInterp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (131, 55, 'DAT', 'DATInterp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (132, 155, 'DAT', 'DATInterp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (133, 56, 'DAT', 'IgG', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (134, 156, 'DAT', 'IgG', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (135, 58, 'DAT', 'IgGInterp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (136, 158, 'DAT', 'IgGInterp', NULL, '2016-01-27 20:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (137, 22, 'Patient ABORh', 'A1Cells', NULL, '2016-01-21 12:40:03.947', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (138, 122, 'Patient ABORh', 'A1Cells', NULL, '2016-01-21 12:46:02.890', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (139, 18, 'Patient ABORh', 'ABOInterp', NULL, '2016-01-21 12:37:38.250', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (140, 118, 'Patient ABORh', 'ABOInterp', NULL, '2016-01-21 12:43:44.550', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (141, 18, 'Patient ABORh', 'ABORhInterp', 21, '2016-01-21 12:38:00.337', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (142, 118, 'Patient ABORh', 'ABORhInterp', 121, '2016-01-21 12:44:23.730', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (143, 15, 'Patient ABORh', 'AntiA', NULL, '2016-01-21 12:36:28.423', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (144, 115, 'Patient ABORh', 'AntiA', NULL, '2016-01-21 12:41:38.173', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (145, 17, 'Patient ABORh', 'AntiAB', NULL, '2016-01-21 12:37:07.193', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (146, 117, 'Patient ABORh', 'AntiAB', NULL, '2016-01-21 12:41:54.057', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (147, 16, 'Patient ABORh', 'AntiB', NULL, '2016-01-21 12:36:57.443', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (148, 116, 'Patient ABORh', 'AntiB', NULL, '2016-01-21 12:41:53.320', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (149, 19, 'Patient ABORh', 'AntiD', NULL, '2016-01-21 12:38:51.293', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (150, 119, 'Patient ABORh', 'AntiD', NULL, '2016-01-21 12:45:08.487', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (151, 19, 'Patient ABORh', 'AntiD1', NULL, '2016-02-03 10:12:32.877', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (152, 19, 'Patient ABORh', 'AntiD2', NULL, '2016-02-03 10:12:47.570', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (153, 119, 'Patient ABORh', 'AntiD1', NULL, '2016-02-03 10:13:23.530', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (154, 119, 'Patient ABORh', 'AntiD2', NULL, '2016-02-03 10:13:30.490', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (155, 24, 'Patient ABORh', 'BCells', NULL, '2016-01-21 12:40:14.997', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (156, 124, 'Patient ABORh', 'BCells', NULL, '2016-01-21 12:46:14.917', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (157, 20, 'Patient ABORh', 'DControl', NULL, '2016-01-21 12:39:04.890', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (158, 120, 'Patient ABORh', 'DControl', NULL, '2016-01-21 12:45:22.950', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (159, 21, 'Patient ABORh', 'RhInterp', NULL, '2016-01-21 12:38:19.017', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (160, 121, 'Patient ABORh', 'RhInterp', NULL, '2016-01-21 12:45:37.533', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (161, 69, 'TAS', 'A1Cells', NULL, '2016-01-21 12:40:03.947', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (162, 65, 'TAS', 'ABOInterp', NULL, '2016-01-21 12:37:38.250', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (163, 65, 'TAS', 'ABORhInterp', 68, '2016-01-21 12:38:00.337', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (164, 92, 'TAS', 'ABSInterp', NULL, '2016-01-21 12:40:14.997', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (165, 62, 'TAS', 'AntiA', NULL, '2016-01-21 12:36:28.423', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (166, 64, 'TAS', 'AntiAB', NULL, '2016-01-21 12:37:07.193', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (167, 63, 'TAS', 'AntiB', NULL, '2016-01-21 12:36:57.443', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (168, 66, 'TAS', 'AntiD', NULL, '2016-01-21 12:38:51.293', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (169, 66, 'TAS', 'AntiD1', NULL, '2016-02-02 16:05:06.993', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (170, 66, 'TAS', 'AntiD2', NULL, '2016-02-02 16:05:12.597', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (171, 71, 'TAS', 'BCells', NULL, '2016-01-21 12:40:14.997', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (172, 67, 'TAS', 'DControl', NULL, '2016-01-21 12:39:04.890', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (173, 68, 'TAS', 'RhInterp', NULL, '2016-01-21 12:38:19.017', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (174, 74, 'TAS', 'SC1', NULL, '2016-01-21 12:38:19.017', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (175, 78, 'TAS', 'SC2', NULL, '2016-01-21 12:38:51.293', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (176, 82, 'TAS', 'SC3', NULL, '2016-01-21 12:39:04.890', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (177, 86, 'TAS', 'SC4', NULL, '2016-01-21 12:40:03.947', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (178, 90, 'TAS', 'SC5', NULL, '2016-01-21 12:40:14.997', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (179, 18, 'Unit ABORh', 'ABOInterp', NULL, '2016-01-13 10:41:25.780', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (180, 18, 'Unit ABORh', 'ABORhInterp', 21, '2016-01-18 14:40:53.737', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (181, 15, 'Unit ABORh', 'AntiA', NULL, '2016-01-13 10:36:50.363', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (182, 17, 'Unit ABORh', 'AntiAB', NULL, '2016-01-13 10:37:49.900', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (183, 16, 'Unit ABORh', 'AntiB', NULL, '2016-01-13 10:37:12.030', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (184, 19, 'Unit ABORh', 'AntiD', NULL, '2016-01-13 10:38:12.857', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (185, 20, 'Unit ABORh', 'DControl', NULL, '2016-01-13 10:40:34.997', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (186, 21, 'Unit ABORh', 'RhInterp', NULL, '2016-01-13 10:41:58.917', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (187, 204, 'Weak D', 'AntiD', NULL, '2016-01-19 12:17:29.787', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (188, 604, 'Weak D', 'AntiD', NULL, '2016-01-30 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (189, 29, 'Weak D', 'DControl', NULL, '2016-01-19 12:18:00.763', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (190, 554, 'Weak D', 'DControl', NULL, '2016-01-30 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (191, 206, 'Weak D', 'WeakDInterp', NULL, '2016-01-19 12:18:38.313', 'DNS   STEPHR', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (192, 606, 'Weak D', 'WeakDInterp', NULL, '2016-01-30 12:00:00.000', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (193, 100, 'XM', 'AHG', NULL, '2016-02-03 14:22:13.653', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (194, 166, 'XM', 'AHG', NULL, '2016-02-03 14:24:41.490', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (195, 2140, 'XM', 'AHGInterp', NULL, '2016-02-03 14:23:08.670', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (196, 98, 'XM', 'IS', NULL, '2016-02-03 14:21:56.597', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (197, 164, 'XM', 'IS', NULL, '2016-02-03 14:24:28.477', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (198, 2139, 'XM', 'ISInterp', NULL, '2016-02-03 14:23:00.170', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (199, 102, 'XM', 'XMInterp', NULL, '2016-02-03 14:22:37.797', 'DNS   DOBRAK', 0)
INSERT INTO [dbo].[BloodTestTypeMapping] ([BloodTestTypeMappingId], [BloodTestTypeId], [BloodPanelName], [BloodTestName], [AntigenTestTypeId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (200, 168, 'XM', 'XMInterp', NULL, '2016-02-03 14:24:54.327', 'DNS   DOBRAK', 0)
-- Operation applied to 200 rows out of 200

--Adding Recommended Indexes
--[dbo].[spGetBloodUnitTestingWorklist] recommended by SQL Server
IF EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode' AND object_id = OBJECT_ID('[dbo].[BloodUnitTest]'))
BEGIN 
DROP INDEX [IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode] ON [dbo].[BloodUnitTest];
END
CREATE NONCLUSTERED INDEX [IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode]
ON [dbo].[BloodUnitTest] ([DivisionCode],[BloodTestTypeId],[TestDate],[RecordStatusCode])
INCLUDE ([BloodUnitTestGuid],[BloodUnitGuid],[TestTechId],[TestResultId],[EntryTechId],[TestingMethodCode],[TestComments],[AntiseraWorklistTypingGuid],[ConfirmationWorklistUnitGuid],[InactivateDate],[InactivateUser],[RackGuid],[AutoInstrumentName],[LastUpdateDate],[LastUpdateUser])
GO


--[dbo].[spGetOrderedUnitsForUnit]
IF EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode' AND object_id = OBJECT_ID('[dbo].[OrderedUnit]'))
BEGIN 
DROP INDEX [IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode] ON [dbo].[OrderedUnit];
END
CREATE NONCLUSTERED INDEX [IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode]
ON [dbo].[OrderedUnit] ([ReleaseDate],[DivisionCode],[RecordStatusCode])
GO


-- [dbo].[spHL7GetXMBySpecimenUIDAndUnitID] recommended by SQL Server
IF EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_BloodUnit_EyeReadableUnitId' AND object_id = OBJECT_ID('[dbo].[BloodUnit]'))
BEGIN 
DROP INDEX [IX_BloodUnit_EyeReadableUnitId] ON [dbo].[BloodUnit];
END
CREATE NONCLUSTERED INDEX [IX_BloodUnit_EyeReadableUnitId]
ON [dbo].[BloodUnit] ([EyeReadableUnitId])
GO



--[dbo].[spGetDivisionWorkloadReport] recommended by SQL Server
IF EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate' AND object_id = OBJECT_ID('[dbo].[WorkloadEvent]'))
BEGIN 
DROP INDEX [IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate] ON [dbo].[WorkloadEvent];
END
CREATE NONCLUSTERED INDEX [IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate]
ON [dbo].[WorkloadEvent] ([RecordStatusCode],[WorkloadEventDate])
INCLUDE ([WorkloadProcessGuid],[WorkloadEventStatusCode],[WeightMultiplier],[DivisionCode])
GO




USE @DBNAME@_MIRROR
GO


if exists (select * from dbo.sysobjects where id = object_id(N'dbo.PendingBloodUnitTest') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.PendingBloodUnitTest
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[PendingBloodUnitTest](
	[MirrorId] [int] IDENTITY(1,1) NOT NULL,
	[PendingBloodUnitTestId] [int] NOT NULL,
	[BloodUnitTestGuid] [uniqueidentifier] NULL,
	[BloodUnitGuid] [uniqueidentifier] NULL,
	[BloodTestTypeId] [int] NOT NULL,
	[BloodUnitId] [varchar](13) NOT NULL,
	[TestDate] [datetime] NOT NULL,
	[TestTechId] [varchar](30) NOT NULL,
	[TestResultId] [char](3) NOT NULL,
	[AutoInstrumentComments] [varchar](510) NULL,
	[OrderedTestGuid] [uniqueidentifier] NULL,
	[OrderedComponentGuid] [uniqueidentifier] NULL,
	[AutoInstrumentName] [varchar](50) NOT NULL,
	[DivisionCode] [char](5) NOT NULL,
	[PendingTestStatusId] [tinyint] NOT NULL,
	[RejectionComment] [varchar] (510) NULL,
	[UnitResultSetGuid] [uniqueidentifier] NOT NULL,
	[OrderedUnitGuid] [uniqueidentifier] NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [binary](8) NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
	[MirrorDate] [datetime] NOT NULL
 CONSTRAINT [PK_PendingBloodUnitTest] PRIMARY KEY NONCLUSTERED 
(
	[MirrorId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


GO

SET ANSI_PADDING OFF
GO


if exists (select * from dbo.sysobjects where id = object_id(N'dbo.PendingSpecimenTest') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.PendingSpecimenTest
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[PendingSpecimenTest](
	[MirrorId] [int] IDENTITY(1,1) NOT NULL,
	[PendingSpecimenTestId] [int] NOT NULL,
	[SpecimenTestGuid] [uniqueidentifier] NULL,
	[OrderedTestGuid] [uniqueidentifier] NOT NULL,
	[PatientSpecimenGuid] [uniqueidentifier] NOT NULL,
	[BloodTestTypeId] [int] NOT NULL,
	[TestDate] [datetime] NOT NULL,
	[TestTechId] [varchar](30) NOT NULL,
	[TestResultId] [char](3) NOT NULL,
	[AutoInstrumentName] [varchar](50) NOT NULL,
	[AutoInstrumentComments] [varchar](510) NULL,
	[DivisionCode] [char](5) NOT NULL,
	[PendingTestStatusId] [tinyint] NOT NULL,
	[RejectionComment] [varchar] (510) NULL,
	[SpecimenResultSetGuid] [uniqueidentifier] NOT NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [binary](8) NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
	[MirrorDate] [datetime] NOT NULL
 CONSTRAINT [PK_PendingSpecimenTest] PRIMARY KEY NONCLUSTERED 
(
	[MirrorId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


GO

SET ANSI_PADDING OFF
GO

--Create Mirror Synonyms
CREATE SYNONYM [dbo].[Syn_PendingSpecimenTest] FOR [@DBNAME@].[dbo].[PendingSpecimenTest]
GO

CREATE SYNONYM [dbo].[Syn_PendingBloodUnitTest] FOR [@DBNAME@].[dbo].[PendingBloodUnitTest]
GO


USE [@DBNAME@]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trMirrorPendingBloodUnitTest]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trMirrorPendingBloodUnitTest]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[trMirrorPendingBloodUnitTest]
ON [dbo].[PendingBloodUnitTest]
FOR UPDATE 
AS 
BEGIN
	INSERT INTO [dbo].[SynMirror_PendingBloodUnitTest]
	SELECT *, GETUTCDATE()
	FROM DELETED
END



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trMirrorPendingSpecimenTest]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trMirrorPendingSpecimenTest]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[trMirrorPendingSpecimenTest]
ON [dbo].[PendingSpecimenTest]
FOR UPDATE 
AS 
BEGIN
	INSERT INTO [dbo].[SynMirror_PendingSpecimenTest]
	SELECT *, GETUTCDATE()
	FROM DELETED
END



GO

USE [@DBNAME@_MIRROR]
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_PendingBloodUnitTest]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_PendingBloodUnitTest
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [dbo].[V_PendingBloodUnitTest]
AS 
SELECT Source='MIRROR', MirrorId, PendingBloodUnitTestId, BloodUnitTestGuid, BloodUnitGuid, BloodTestTypeId, BloodUnitId, TestDate, TestTechId, TestResultId, AutoInstrumentComments, OrderedTestGuid, OrderedComponentGuid, AutoInstrumentName, DivisionCode, PendingTestStatusId, RejectionComment, UnitResultSetGuid, OrderedUnitGuid, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.PendingBloodUnitTest
UNION ALL 
SELECT Source='ACTIVE', 0, PendingBloodUnitTestId, BloodUnitTestGuid, BloodUnitGuid, BloodTestTypeId, BloodUnitId, TestDate, TestTechId, TestResultId, AutoInstrumentComments, OrderedTestGuid, OrderedComponentGuid, AutoInstrumentName, DivisionCode, PendingTestStatusId, RejectionComment, UnitResultSetGuid, OrderedUnitGuid, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_PendingBloodUnitTest
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_PendingSpecimenTest]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_PendingSpecimenTest
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [dbo].[V_PendingSpecimenTest]
AS 
SELECT Source='MIRROR', MirrorId, PendingSpecimenTestId, SpecimenTestGuid, OrderedTestGuid, PatientSpecimenGuid, BloodTestTypeId, TestDate, TestTechId, TestResultId, AutoInstrumentName, AutoInstrumentComments, DivisionCode, PendingTestStatusId, RejectionComment, SpecimenResultSetGuid, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.PendingSpecimenTest
UNION ALL 
SELECT Source='ACTIVE', 0, PendingSpecimenTestId, SpecimenTestGuid, OrderedTestGuid, PatientSpecimenGuid, BloodTestTypeId, TestDate, TestTechId, TestResultId, AutoInstrumentName, AutoInstrumentComments, DivisionCode, PendingTestStatusId, RejectionComment, SpecimenResultSetGuid, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_PendingSpecimenTest
GO


--Permissions

GRANT SELECT, INSERT ON dbo.[PendingBloodUnitTest] TO VbecsAppMirrorUser
GO

GRANT SELECT, INSERT ON dbo.[PendingSpecimenTest] TO VbecsAppMirrorUser
GO

GRANT SELECT ON dbo.V_PendingBloodUnitTest TO VbecsAppMirrorUser
GO

GRANT SELECT ON dbo.V_PendingSpecimenTest TO VbecsAppMirrorUser
GO


USE [@DBNAME@]
GO


CREATE SYNONYM [dbo].[SynMirror_V_PendingBloodUnitTest] FOR [@DBNAME@_MIRROR].[dbo].[V_PendingBloodUnitTest]
GO


CREATE SYNONYM [dbo].[SynMirror_V_PendingSpecimenTest] FOR [@DBNAME@_MIRROR].[dbo].[V_PendingSpecimenTest]
GO


--Add Index [MessageLog_MessageLogControlId]  (Defect 229902) 
CREATE NONCLUSTERED INDEX [IX_MessageLog_MessageControlId] ON [dbo].[MessageLog] ([MessageControlId]) ON [PRIMARY]
GO


--Change the cloumn length for TaskStatusText from VARCHAR(25) to VARCHAR(40) -BR 92.02 updates
ALTER TABLE [dbo].[TaskStatus] ALTER COLUMN [TaskStatusText] [varchar] (40) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The current state of the task to fill an order.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'TaskStatusCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Describes the task status code.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'TaskStatusText'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A number that facilitates presenting values in a specified order.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'SortColumn'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date the associated record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The LogonId of the user who made the last update to the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TaskStatus', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO


-- Update row in [dbo].[ExceptionType]-Defect 286183
UPDATE [dbo].[ExceptionType] SET [BusinessRule]='56.12, 56.16, 56.28, 115.18, 115.27', [LastUpdateDate]='2106-05-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [ExceptionTypeId]=31

-- Add row to [dbo].[TaskStatus]
INSERT INTO [dbo].[TaskStatus] ([TaskStatusCode], [TaskStatusText], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES ('A', 'Instrument Results Pending Review', 8, '2016-01-28 11:11:08.393', 'DNS   STEPHR', 0)


-- Add a row to [dbo].[CannedCommentCategory]-Defects 251422 and 315434

INSERT INTO [dbo].[CannedCommentCategory] ([CannedCommentCategoryCode], [CannedCommentCategoryText], [LockingGuid], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES ('AR', 'Automated Testing Review', 'f023ebb3-11db-4f5a-a4d1-8a7deee8fed1', 2, '2016-05-05 00:00:00.000', 'DNS   adupok', 0)


-- Add rows to [dbo].[tmplCannedComment] -Defect 251422
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('7be58859-cfe6-498a-b8ef-02be98ef5a8b', 'Remote Data Record reviewed, history', 'AR', 7, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('92b14168-5152-4fdf-bfc0-0b176d94314c', 'Control NEG', 'AR', 4, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('dfff4240-a2ab-4709-9f93-25cf036e2a47', 'Results confirmed with tube testing', 'AR', 2, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('23e993ac-3501-4d64-bb1f-2abf42f33004', 'Rh (D) control negative', 'AR', 3, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('6eff400a-edb6-40ad-895d-900359e8de2d', 'Control POS', 'AR', 5, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('5c3d4efb-d02c-4f1b-94c0-c04d8ba28230', 'Remote Data Record reviewed, no history', 'AR', 6, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('4312b8d6-8e7d-4ead-a9f2-e7d9cde70517', 'Other', 'AR', 1, 'A')
INSERT INTO [dbo].[tmplCannedComment] ([CannedCommentGuid], [CannedCommentText], [CannedCommentCategoryCode], [SortColumn], [RecordStatusCode]) VALUES ('42cd7464-d99c-43c9-9b6b-e9a6339aa890', 'Post-transfusion reaction', 'AR', 8, 'A')
-- Operation applied to 8 rows out of 8

-- Update rows in [dbo].[CannedCommentCategory]
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=5, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='AB'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=6, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='AD'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=4, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='IS'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=7, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='OC'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=8, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='OP'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=9, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='PS'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=10, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='PT'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=11, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='QD'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=13, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='QR'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=14, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='RR'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=12, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='RS'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=17, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SE'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=18, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SG'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=16, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SI'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=19, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SP'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=23, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SR'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=20, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SU'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=15, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='SX'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=24, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='T1'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=25, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='T2'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=26, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='T3'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=27, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='T4'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=28, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='TB'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=29, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='TC'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=21, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='TP'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=22, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='TW'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=30, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='TX'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=33, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UI'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=34, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UM'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=35, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UR'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=37, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='US'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=39, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UT'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=32, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UV'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=36, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UX'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=38, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UY'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=31, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='UZ'
UPDATE [dbo].[CannedCommentCategory] SET [SortColumn]=3, [LastUpdateDate]='2016-02-19 00:00:00.000', [LastUpdateUser]='DNS   adupok' WHERE [CannedCommentCategoryCode]='XM'
-- Operation applied to 37 rows out of 37


--Populate the CannedComment table 
DECLARE @now DATETIME 
        SET @now = GETUTCDATE() 
        INSERT INTO dbo.CannedComment 
        ( 
                        CannedCommentGuid, 
                        CannedCommentText, 
                        CannedCommentCategoryCode, 
                        SortColumn, 
                        RecordStatusCode, 
                        DivisionCode, 
                        LastUpdateDate, 
                        LastUpdateUser, 
                        LastUpdateFunctionId 
        ) 


        SELECT  

                NEWID(), 
                 tcc.CannedCommentText, 
                 tcc.CannedCommentCategoryCode, 
                 tcc.SortColumn, 
                 tcc.RecordStatusCode, 
                 div.DivisionCode, 
                 @now, 
                (select top 1 vu.vbecsuserid from VbecsUser vu 
                            join VbecsUserDivisionRole vdr on vu.VbecsUserId = vdr.VbecsUserId
                           where vdr.DivisionCode= div.DivisionCode AND vdr.UserRoleId = 6 AND vdr.RecordStatusCode = 'A' order by SystemUserIndicator), 
 
                 0 

        FROM    
                dbo.tmplCannedComment tcc, VamcDivision div 
        WHERE tcc.CannedCommentCategoryCode ='AR'

-- Add rows to [dbo].[VbecsProcess] -Defects 251218 & 251173 
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (56, '70d8648c-938b-489e-8c82-df0157668006', 'Patient ABO Automated', 'P', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (57, '3f8de916-8ca4-4c9d-b659-5fb20f72254b', 'Antibody Screen/Indirect Coombs Automated', 'P', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (58, 'ce197f0b-1c90-4440-85fd-c7117d08320f', 'Serologic Crossmatch, Major, Automated', 'P', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (59, '094b0a1d-ba0d-4a98-be81-f1c197943261', 'Direct Antiglobulin Test Automated', 'P', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (60, '7c101762-2c25-461e-9e8a-77fd92941a21', 'Patient Antigen Typing Automated', 'P', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (61, '48eaee65-e46f-4ad3-badc-ddb46dd72664', 'Blood Unit ABO Confirmation Test Automated', 'U', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (62, 'd00d9c84-0f69-4970-a4ca-bd3fa647c9bc', 'Blood Unit ABO/Rh Confirmation Test Automated', 'U', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
INSERT INTO [dbo].[VbecsProcess] ([VbecsProcessId], [VbecsProcessGuid], [VbecsProcessName], [TransactionType], [RecordStatusCode], [SortColumn], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (63, '1d1f1ccf-2d31-408a-9942-b7e8871f4aa4', 'Blood Unit Antigen Typing Automated', 'U', 'A', 0, '2016-01-05 00:00:00.000', 'DNS   adupok', 0)
-- Operation applied to 8 rows out of 8

-- allowing Null for LotExpiration
ALTER TABLE [dbo].[ExceptionPatientAntigenDiscrepancy] ALTER COLUMN [LotExpirationDate] [datetime] NULL
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an instance of a patient antigen discrepancy exception.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ExceptionPatientAntigenDiscrepancyGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a classification of exceptions.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ExceptionTypeId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full name of the patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'PatientName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The displayed VistA patient identifier.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'PatientId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier for a patient generated by VBECS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'PatientGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The specimen unit identifier from VistA.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'SpecimenUid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the reagent type associated with the antigen discrepancy.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ReagentTypeName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The manufacturer''s name for the reagent product.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ReagentName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A reference to the manufacturer''s production lot.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'LotNumber'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the company that produced the reagent.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ReagentManufacturerName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date the reagent lot expires.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'LotExpirationDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Details of the specimen test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'HistoricSpecimenTestResults'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The latest specimen test results.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'CurrentSpecimenTestResults'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the tech that performed the blood unit test.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'TestingTechName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user that created the exception event.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ExceptionUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Details of the exception event.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ExceptionComment'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date of the exception event' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'ExceptionDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the division in which the exception event took place.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'DivisionCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date the associated record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The LogonId of the user who made the last update to the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExceptionPatientAntigenDiscrepancy', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO




--Adding Stored Procedures
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7InsertPendingSpecimenTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7InsertPendingSpecimenTest]
GO

/****** Object:  StoredProcedure [dbo].[spHL7InsertPendingSpecimenTest]    Script Date: 2/17/2016 3:20:41 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc: 	Inserts a record in the PendingSpecimenTest table.
**		Used in sending VISTA information to VBECS (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	12/29/2015
*******************************************************************************************************************************************************************************
**	Modified
**	Date			Developer				Comments
**	--------------	-----------------------	-------------------------------------------------------------------------------------------------------------------------------
**	1/25/2016	Russell Stephenson	Defect 235352: Added @SpecimenTestGuid with default to null, corrected the lengths of the char values for @TestResultId and @DivisionCode.
															and  corrected the lengths of the char and varchar values.
**	02/17/2016	Russell Stephenson	Defect 235352: Added Timezone correction.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7InsertPendingSpecimenTest]
(
		@specimentestguid UNIQUEIDENTIFIER = NULL,
		@orderedtestguid	UNIQUEIDENTIFIER,
		@patientspecimenguid	UNIQUEIDENTIFIER,
		@bloodtesttypeId	INT,
		@testdate	DATETIME,
		@testtechid	VARCHAR (30),
		@testresultid	CHAR (3),
		@autoinstrumentname	VARCHAR (50),
		@autoinstrumentcomments	VARCHAR (510),
		@divisioncode	CHAR (5),
		@pendingteststatusid	TINYINT,
		@specimenresultsetguid	UNIQUEIDENTIFIER,
		@lastupdatedate	DATETIME,
		@lastupdateuser	VARCHAR (30),
		@lastupdatefunctionid	INT
)

AS

SET NOCOUNT ON

DECLARE @ERROR	INT,
	@ROWCOUNT	INT

	INSERT INTO dbo.PendingSpecimenTest
           (
            SpecimenTestGuid,
			OrderedTestGuid,
            PatientSpecimenGuid,
            BloodTestTypeId,
            TestDate,
            TestTechId,
            TestResultId,
            AutoInstrumentName,
            AutoInstrumentComments,
            DivisionCode,
            PendingTestStatusId,
            SpecimenResultSetGuid,
            LastUpdateDate,
            LastUpdateUser,
            LastUpdateFunctionId
			)
     VALUES
		   (
		    @specimentestguid,
			@orderedtestguid,
			@patientspecimenguid,
			@bloodtesttypeid,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @testdate),
			@testtechId,
			@testresultid,
			@autoinstrumentname,
			@autoinstrumentcomments,
			@divisioncode,
			@pendingteststatusid,
			@specimenresultsetguid,
			@lastupdatedate,
			@lastupdateuser,
			@lastupdatefunctionid
			)

	SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT
	
	IF (@ERROR = 0)
		IF @ROWCOUNT <> 1	
			SET @ERROR = -1


SET NOCOUNT OFF

RETURN (@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7InsertPendingBloodUnitTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7InsertPendingBloodUnitTest]
GO


/****** Object:  StoredProcedure [dbo].[spHL7InsertPendingBloodUnitTest]    Script Date: 2/17/2016 3:17:15 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc: 	Inserts a record in the patient table.
**		Used in sending VISTA information to VBECS (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	12/29/2015
*******************************************************************************************************************************************************************************
**	Modified
**	Date		Developer		Comments
**	--------------	-----------------------	-------------------------------------------------------------------------------------------------------------------------------
**	2/3/2016	Russell Stephenson	Defect 235352: Added @orderedunitguid and OrderedUnitGuid.
**	2/5/2016	Russell Stephenson	Defect 235352: Defaulted @orderedunitguid to null.
**	2/17/2016	Russell Stephenson	Defect 235352: Added Timezone correction.
**	2/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7InsertPendingBloodUnitTest]
(
		@bloodunittestguid	UNIQUEIDENTIFIER = NULL,
		@bloodunitguid	UNIQUEIDENTIFIER = NULL,
		@bloodtesttypeid	INT,
		@bloodunitid	VARCHAR (13),
		@testdate	DATETIME,
		@testtechId	VARCHAR (30),
		@testresultid	CHAR (3),
		@autoinstrumentcomments	VARCHAR (510) = NULL,
		@orderedtestguid	UNIQUEIDENTIFIER = NULL,
		@orderedcomponentguid	UNIQUEIDENTIFIER = NULL,
		@autoinstrumentname	VARCHAR (50),
		@divisioncode	CHAR (5),
		@pendingteststatusid	TINYINT,
		@unitresultsetguid	UNIQUEIDENTIFIER,
		@orderedunitguid	UNIQUEIDENTIFIER = NULL,
		@lastupdatedate	DATETIME,
		@lastupdateuser	VARCHAR (30),
		@lastupdatefunctionid	INT
)

AS

SET NOCOUNT ON

DECLARE @ERROR	INT,
		@ROWCOUNT	INT

	INSERT INTO dbo.PendingBloodUnitTest
           (
			BloodUnitTestGuid,
            BloodUnitGuid,
            BloodTestTypeId,
            BloodUnitId,
            TestDate,
            TestTechId,
            TestResultId,
            AutoInstrumentComments,
            OrderedTestGuid,
            OrderedComponentGuid,
            AutoInstrumentName,
            DivisionCode,
            PendingTestStatusId,
            UnitResultSetGuid,
			OrderedUnitGuid,
            LastUpdateDate,
            LastUpdateUser,
            LastUpdateFunctionId
			)
     VALUES
			(
			@bloodunittestguid,
			@bloodunitguid,
			@bloodtesttypeid,
			@bloodunitid,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @testdate),
			@testtechid,
			@testresultid,
			@autoinstrumentcomments,
			@orderedtestguid,
			@orderedcomponentguid,
			@autoinstrumentname,
			@divisioncode,
			@pendingteststatusid,
			@unitresultsetguid,
			@orderedunitguid,
			@lastupdatedate,
			@lastupdateuser,
			@lastupdatefunctionid
			)

	SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT
	
	IF (@ERROR = 0)
		IF @ROWCOUNT <> 1	
			SET @ERROR = -1


SET NOCOUNT OFF

RETURN (@ERROR)




GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPendingBloodUnitTests]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPendingBloodUnitTests]
GO

/****** Object:  StoredProcedure [dbo].[spGetPendingBloodUnitTests]    Script Date: 3/10/2016 10:04:48 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO






/********************************************************************************************************************************
**	Desc:	Returns records from PendingBloodUnitTest table (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	12/11/2015
*********************************************************************************************************************************
**	Modified
**	Date		Name			Description
**	----------	--------		-------------------------
**	02/02/2016	Lohse			Adding join for BloodUnitStatusGuid (locking) needed for Defect 251417.	
**	02/05/2016	Doug Forst		Defect 235354 - Adding OrderedUnitGuid to select list
**	02/12/2016	K.Adu-Poku		Changed RejectComment to RejectionComment
**	02/17/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	03/02/2016	Doug Forst		Defect 286187: Added error handling and changed DateTimes to return the division's local DateTime
**	03/31/2016	P. Sanchez		** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetPendingBloodUnitTests]
(
	@divisioncode	CHAR(5),
	@pendingteststatusid	TINYINT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT
		PBUT.PendingBloodUnitTestId, 
		PBUT.BloodUnitTestGuid, 
		PBUT.BloodUnitGuid,
		PBUT.BloodTestTypeId,
		BTT.BloodTestName  AS BloodTestTypeName,
		BTT.SortColumn AS BloodTestTypeSortOrder,
		PBUT.BloodUnitId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PBUT.TestDate) AS TestDate,
		PBUT.TestTechId,
		VU.UserName AS TestTechUserName,
		PBUT.TestResultId,
		TR.TestResultText, 
		PBUT.AutoInstrumentComments, 
		PBUT.OrderedUnitGuid,
		PBUT.OrderedTestGuid,
		PBUT.OrderedComponentGuid,
		PBUT.AutoInstrumentName,
		PBUT.DivisionCode,
		PBUT.PendingTestStatusId,
		PBUT.RejectionComment,
		PBUT.UnitResultSetGuid,
		OT.OrderableTestId,
		OT.OrderableTestName, 
		BTT.TestedWith AS BloodTestTypeTestedWith,
		PBUT.LastUpdateUser,
		PBUT.[RowVersion]
	  FROM 
	  
		dbo.PendingBloodUnitTest PBUT

		JOIN dbo.TestResult TR ON TR.TestResultID = PBUT.TestResultID

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = PBUT.BloodTestTypeId

		JOIN dbo.OrderableTest OT ON OT.OrderableTestId = BTT.OrderableTestId
		
		LEFT JOIN dbo.VbecsUser VU ON VU.VbecsUserId = PBUT.TestTechId

	  WHERE 
	  
		DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

	

	-- Select matching product codes
	SELECT DISTINCT
		BU.BloodUnitGuid,
		BUS.BloodUnitStatusGuid,
		BU.UnitProductCode,
		DT.DonationTypeCode,
		BU.UnitDivisionId,
		BUM.BloodTypeCode,
		BUM.RhFactorCode,
		RHF.RhFactorText,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.UnitExpirationDate) AS UnitExpirationDate,
		PT.ProductTypeName,
		BP.ProductShortName,
		BUS.[RowVersion] as BloodUnitStatusRowVersion,
		BUSCC.UnitStatusCode,
		BU.LabelTypeCode

	FROM 
		dbo.BloodUnit BU

		JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitGuid = BU.BloodUnitGuid
		
		JOIN dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BU.BloodUnitGuid
		
		JOIN dbo.RhFactor RHF ON RHF.RhFactorCode = BUM.RhFactorCode

		JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid

		JOIN dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
		
		JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid
		
		JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BUSCC.BloodUnitGuid = BU.BloodUnitGuid
		
		LEFT JOIN dbo.DonationType DT ON DT.DonationTypeId = BU.DonationTypeId

	WHERE 
		PBUT.DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid



SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)





GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodUnitsByUnitId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodUnitsByUnitId]
GO


/****** Object:  StoredProcedure [dbo].[spGetBloodUnitsByUnitId]    Script Date: 3/16/2016 10:20:36 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/****************************************************************************************************************************************************
**	Desc:	Gets Blood Unit By Unit Id Product (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	12/22/2015
**
*****************************************************************************************************************************************************
**	Modified:
**	Date			Name				Description
**	-------------	---------			-----------------
**	01/25/2016	Russell Stephenson	Defect 235352: Took out comments and verified that this projection is being used by UC_115 and UC_114.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/16/2016	Douglas Forst	Defect 286187 changed sproc name from spGetBloodUnitByUnitId to spGetBloodUnitsByUnitId
**	03/31/2016	P. Sanchez	** Reviewed for compliance with database standards and recommendations **
******************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsByUnitId]
(
	@unitid		VARCHAR(13),
	@divisioncode			CHAR(5)
)
AS
	
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON


	SELECT        

		BUT.BloodUnitGuid, 
		BUS.BloodUnitStatusGuid,		
		BUT.UnitProductCode, 
		BP.ProductShortName,
		PT.ProductTypeName,
		PT.SortColumn AS ProductTypeSortColumn,
		BUT.OriginalVolume, 
		BUT.DiscardedPlasmaVolume, 

		dbo.fnGetPooledUnitsCount(BUT.BloodUnitGuid) 					AS PooledUnitsCount, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.UnitInDate) 		AS UnitInDate, 

		BUT.UnitFdaRegistrationNumber, 
		BUT.UnitContainerLotNumber, 
		BUT.DonationTypeID,
		DT.DonationTypeCode,
		BUT.UnitDivisionID, 
		BUT.LabelTypeCode, 
		BUT.LabelUnitID, 
		BUT.EyeReadableUnitID, 
		BUT.BloodProductGUID, 
		BUCS.IncomingShipmentGuid,

		BUT.DivisionCode, 
		BUT.EntryMethodCode, 
		BUT.ProcessingTechID,
		BUT.RecordStatusCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) 	AS LastUpdateDate, 

		BUT.LastUpdateUser, 
		BUT.[RowVersion],
		dbo.fnIsUnitPendingTransfer(BUT.BloodUnitGuid) AS PendingTransferIndicator,
		BUM.BloodTypeCode, 
		BUM.RhFactorCode,
		RHF.RhFactorText,
		BUS.[RowVersion] as BloodUnitStatusRowVersion,
		BUSCC.UnitStatusCode
	FROM

		dbo.BloodUnit BUT
	
		JOIN dbo.BloodUnitCurrentShipment BUCS ON BUCS.BloodUnitGuid = BUT.BloodUnitGuid
		
		JOIN dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BUT.BloodUnitGuid

		JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BUT.BloodUnitGuid

		JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BUSCC.BloodUnitGuid = BUT.BloodUnitGuid
		
		JOIN dbo.RhFactor RHF ON RHF.RhFactorCode = BUM.RhFactorCode

		JOIN dbo.DonationType DT ON DT.DonationTypeID = BUT.DonationTypeID

		JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BUT.BloodProductGuid

		JOIN dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode

	WHERE

		EyeReadableUnitId = @unitid

		AND	DivisionCode = @divisioncode

		AND	BUT.RecordStatusCode <> 'X'

		AND PT.AboRhConfirmationRequired = 1

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPendingBloodUnitTestsCount]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPendingBloodUnitTestsCount]
GO

/****** Object:  StoredProcedure [dbo].[spGetPendingBloodUnitTestsCount]    Script Date: 2/12/2016 8:52:12 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc:	Returns the count of Pending Blood Unit Tests (Defect 235354)
**
**	Author:	Doug Forst
**
**	Date: 	12/29/2015
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	02/09/16	K.Adu-Poku	Changed name from spGetCountOfPendingBloodUnitTests to spGetPendingBloodUnitTestsCount (Defect 235354).
**	02/11/16	Doug Forst	Added Join to BloodTestType to exclude XM and RepeateXM (Defect 235354)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetPendingBloodUnitTestsCount]
(
	@divisioncode	CHAR(5),
	@pendingteststatusid	TINYINT
)
AS

SET NOCOUNT ON
	
	SELECT 
		COUNT(1) AS [Count]

	FROM 
		dbo.PendingBloodUnitTest PBUT

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId =PBUT.BloodTestTypeId

	WHERE 
		DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

		AND BTT.OrderableTestId NOT IN (9, 119) -- Exclude XM and RepeatXM


SET NOCOUNT OFF



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPendingSpecimenTestsCount]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPendingSpecimenTestsCount]
GO

/****** Object:  StoredProcedure [dbo].[spGetPendingSpecimenTestsCount]    Script Date: 2/11/2016 3:40:44 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc:	Returns the count of Pending Specimen Tests (Defect 235354)
**
**	Author:	Doug Forst
**
**	Date: 	12/29/2015
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	02/09/16	K.Adu-Poku	Changed name from spGetCountOfPendingSpecimenTests to spGetPendingSpecimenTestsCount (Defect 235354).
**	02/11/16	Doug Forst	Added Select to PendingBloodUnitTest to include XM and RepeateXM (Defect 235354)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/


CREATE PROCEDURE [dbo].[spGetPendingSpecimenTestsCount]
(
	@divisioncode	CHAR(5),
	@pendingteststatusid	TINYINT
)
AS

SET NOCOUNT ON
	
	DECLARE @pendingspecimencount int
	DECLARE @pendingbloodunitcount int

	SELECT 
		@pendingspecimencount = COUNT(1)

	FROM 
		dbo.PendingSpecimenTest PBUT

	WHERE 
		DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid


	SELECT 
		@pendingbloodunitcount = COUNT(1)

	FROM 
		dbo.PendingBloodUnitTest PBUT

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId =PBUT.BloodTestTypeId

	WHERE 
		DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

		AND BTT.OrderableTestId IN (9, 119) -- Only return XM and RepeatXM


	SELECT @pendingspecimencount + @pendingbloodunitcount as [Count]

SET NOCOUNT OFF


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdatePendingBloodUnitTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdatePendingBloodUnitTest]
GO


/****** Object:  StoredProcedure [dbo].[spUpdatePendingBloodUnitTest]    Script Date: 1/21/2016 8:51:23 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc:	Updates a single PendingBloodUnitTest record (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	01/04/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	02/16/2016	K.Adu-Poku	Changed RejectComment to RejectionComment
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spUpdatePendingBloodUnitTest]
(
	@pendingbloodunittestid INT,
	@bloodunittestguid UNIQUEIDENTIFIER = NULL,
	@pendingteststatusid TINYINT,
	@rejectioncomment VARCHAR (510) = NULL,
	@lastupdatedate DATETIME,
    @lastupdateuser VARCHAR (30),
	@rowversion TIMESTAMP,
    @lastupdatefunctionid INT
)
AS

SET NOCOUNT ON

DECLARE @ERROR  INT
DECLARE @ROWCOUNT INT
	
	UPDATE 
		dbo.PendingBloodUnitTest
	SET 
		PendingTestStatusId = @pendingteststatusid,
		BloodUnitTestGuid = @bloodunittestguid,
		RejectionComment = @rejectioncomment,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		PendingBloodUnitTestId = @pendingbloodunittestid
		AND [RowVersion] = @rowversion

SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM dbo.PendingBloodUnitTest  WHERE [RowVersion] = @rowversion ) <> 1 
	RAISERROR(50001, 16, 127)
ELSE
	IF (@ERROR = 0 AND @ROWCOUNT <> 1)            
		SET @ERROR = -1

SET NOCOUNT OFF
                                
RETURN (@ERROR)
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPatientsWithPendingSpecimenTests]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPatientsWithPendingSpecimenTests]
GO

/****** Object:  StoredProcedure [dbo].[spGetPatientsWithPendingSpecimenTests]    Script Date: 3/8/2016 3:38:18 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc:	Returns records from PendingSpecimenTest table (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	1/18/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	02/05/2016	Doug Forst	Defect 235354 - Added support for returning XM results
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/29/2016	Doug Forst	Defect 284963 - Added support to allow OrderedUnitGuid to be null in PendingBloodUnitTest table
**	02/29/2016	Doug Forst	Defect 282082 - Added support for returning XM results with a null OrderedUnitGuid and removed unused join to Patient
**	03/02/2016	Doug Forst	Defect 286187 - Removed unneeded join to the the Patient table
**	04/26/2016	K. Dobranowski	Added check for NULL on OrderableTestName (Defect 312042)
**	04/29/2016	P. Sanchez	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetPatientsWithPendingSpecimenTests]
(	
	@divisioncode CHAR(5),
	@pendingteststatusid TINYINT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON


-- Select distinct patients and speciemnUids
SELECT DISTINCT 
	PS.SpecimenUid,
	PS.PatientSpecimenGuid,
	PS.PatientGuid
		  
FROM 
	dbo.PendingSpecimenTest PST

	JOIN dbo.PatientSpecimen PS ON PST.PatientSpecimenGuid = PS.PatientSpecimenGuid

WHERE PST.DivisionCode = @divisioncode

	AND PST.PendingTestStatusId = @pendingteststatusid

UNION
-- Select XM Data
SELECT DISTINCT 
	PS.SpecimenUid,
	PS.PatientSpecimenGuid,
	PS.PatientGuid
		  
FROM 
	dbo.PendingBloodUnitTest PBUT

	LEFT JOIN dbo.OrderedUnit OU ON OU.OrderedUnitGuid = PBUT.OrderedUnitGuid

	LEFT JOIN dbo.OrderedTest ORT ON ORT.OrderedTestGuid = PBUT.OrderedTestGuid 

	LEFT JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGuid = PBUT.OrderedComponentGuid 

	JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = ORT.PatientSpecimenGuid
								OR PS.PatientSpecimenGuid = OC.PatientSpecimenGuid

WHERE PBUT.DivisionCode = @divisioncode

	AND PBUT.PendingTestStatusId = @pendingteststatusid


-- Select the unique pending tests
SELECT DISTINCT
	PS.SpecimenUid,
    PST.PatientSpecimenGuid,
    BTT.OrderableTestId,
	OT.OrderableTestName,
	OT.OrderableTestText
FROM 
	dbo.PendingSpecimenTest PST
	
	JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = PST.BloodTestTypeId

	JOIN dbo.PatientSpecimen PS ON PST.PatientSpecimenGuid = PS.PatientSpecimenGuid

	JOIN dbo.OrderableTest OT ON OT.OrderableTestId = BTT.OrderableTestId

WHERE PST.DivisionCode = @divisioncode

	AND PST.PendingTestStatusId = @pendingteststatusid

UNION
-- Select XM Data
SELECT DISTINCT
	PS.SpecimenUid,
    PS.PatientSpecimenGuid,
    BTT.OrderableTestId,
	OT.OrderableTestName,
	OT.OrderableTestText
FROM 
	dbo.PendingBloodUnitTest PBUT

	LEFT JOIN dbo.OrderedUnit OU ON OU.OrderedUnitGuid = PBUT.OrderedUnitGuid

	LEFT JOIN dbo.OrderedTest ORT ON ORT.OrderedTestGuid = PBUT.OrderedTestGuid 

	LEFT JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGuid = PBUT.OrderedComponentGuid 

	JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = ORT.PatientSpecimenGuid
								OR PS.PatientSpecimenGuid = OC.PatientSpecimenGuid
	
	JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = PBUT.BloodTestTypeId

	LEFT JOIN dbo.OrderableTest OT ON OT.OrderableTestId = BTT.OrderableTestId

WHERE PBUT.DivisionCode = @divisioncode

	AND PBUT.PendingTestStatusId = @pendingteststatusid
	AND OT.OrderableTestName IS NOT NULL

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetVbecsUserWithVariableLengthID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetVbecsUserWithVariableLengthID]
GO

/****** Object:  StoredProcedure [dbo].[spHL7GetVbecsUserWithVariableLengthID]    Script Date: 2/1/2016 1:09:49 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc: 	Selects records from the VbecsUser table based on the primary key but allows for Ids that are trimmed on the left (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	1/16/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name				Description
**	------------------------------------------------------------------------------------------------------------------------------------------------------------------
**  1/26/2016  Russell Stephenosn	Defect 235352:  Changed name to spHL7GetVbecsUserWithVariableLengthID to correct spelling.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spHL7GetVbecsUserWithVariableLengthID]
(
	@vbecsuserid 		VARCHAR(30),
	@searchallusers		BIT = 0
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT 	
		VbecsUserId,
		VbecsUserGuid, 
		UserDUZ, 
		UserName, 
		VistAUserName,  
		UserInitials, 
		UserEmail, 
		RecordStatusCode,
		LastUpdateUser,
		LastUpdateDate,		--not used, remove in 2.0
		[RowVersion]
	FROM  	
		dbo.VbecsUser
	WHERE 
 
		VbecsUserId LIKE '%'+@vbecsuserid 

	AND	((SystemUserIndicator <> 1
	
		 AND @searchallusers = 0) 
	
			OR (@searchallusers = 1))

SET @ERROR = @@ERROR

SET NOCOUNT OFF
 
RETURN(@ERROR)



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAboRHConfirmationTestsForUnit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAboRHConfirmationTestsForUnit]
GO

/****** Object:  StoredProcedure [dbo].[spGetAboRHConfirmationTestsForUnit]    Script Date: 2/1/2016 1:07:45 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc:	Gets a blood unit's Abo/Rh Confirmation test results
**
**	Author:	Martin Tsotchev
**
**	Date: 	01/28/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT
					Placed rowcount in square brackets, spaced out SQL, place input params in ()
					NOTE: BloodTestTypeID is hardcoded, consider doing a subquery so that if the Test Typevalues change
					this code will not have to be modified.
**	01/15/2016	K.Dobranowski	Modified this sp to allow loading of the automated instrument tests (they don't have the worklist Guid) (Defect 251282)
**	01/29/2016	K.Dobranowski	Added sorting by unique Guid (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAboRHConfirmationTestsForUnit]
(
		@bloodunitguid		UNIQUEIDENTIFIER,
		@divisioncode		CHAR(5)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BUT.ConfirmationWorklistUnitGUID,
		BUT.BloodUnitTestGUID,
		BUT.BloodUnitGUID,
		BUT.BloodTestTypeID,
		BTT.BloodTestName,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,

		BUT.TestResultID,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		BUT.[RowVersion],
		TR.TestResultText,
		PBUT.UnitResultSetGuid

	FROM

		dbo.BloodUnitTest BUT

		JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		LEFT JOIN dbo.PendingBloodUnitTest PBUT ON BUT.BloodUnitTestGuid = PBUT.BloodUnitTestGuid

	WHERE
		BUT.DivisionCode = @divisioncode

	AND	BUT.BloodUnitGUID = @bloodunitguid

	AND	BUT.RecordStatusCode = 'A'

	AND BUT.BloodTestTypeID IN (15,16,17,18,19,20,21)

	ORDER BY

		ISNULL(PBUT.UnitResultSetGuid, BUT.ConfirmationWorklistUnitGUID) ASC,
		BUT.TestDate DESC
		
	SET @ERROR = @@ERROR

RETURN @ERROR


GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAntigenTypingTestsForUnit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAntigenTypingTestsForUnit]
GO

/****** Object:  StoredProcedure [dbo].[spGetAntigenTypingTestsForUnit]    Script Date: 1/19/2016 10:03:20 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc:	Gets a blood unit's Antigen Typing test results
**
**	Author:	Martin Tsotchev
**
**	Date: 	01/28/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					NOTE: The last subquery was using the same table alias (OrderableTest OT) as in the main query
					I have changed this realizing there is a far off remote chance that the resulting data set may now be different
**	01/15/2016	K.Dobranowski	Modified this sp to allow loading of the automated instrument tests (they don't have the worklist Guid) (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAntigenTypingTestsForUnit]
(
		@bloodunitguid		UNIQUEIDENTIFIER,
		@divisioncode		CHAR(5)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BUT.AntiseraWorklistTypingGUID,
		AWT.OrderableTestID,
		OT.OrderableTestName,
		BUT.BloodUnitTestGUID,
		BUT.BloodUnitGUID,
		BUT.BloodTestTypeID,
		BTT.BloodTestName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,
		BUT.TestResultID,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		BUT.[RowVersion],
		TR.TestResultText,
		R.ReagentGUID,
		PBUT.UnitResultSetGuid

	FROM

		dbo.BloodUnitTest BUT

		JOIN dbo.TestResult TR ON 

			TR.TestResultID = BUT.TestResultID

		JOIN dbo.BloodTestType BTT ON 

			BTT.BloodTestTypeID = BUT.BloodTestTypeID

		LEFT JOIN dbo.AntiseraWorklistTyping AWT ON 

			BUT.AntiseraWorklistTypingGUID = AWT.AntiseraWorklistTypingGUID

		LEFT JOIN dbo.AntiseraUnitTest AUT ON 

			AWT.AntiseraWorklistTypingGUID = AUT.AntiseraWorklistTypingGUID

		LEFT JOIN dbo.RackLot RL ON 

			AUT.RackLotGUID = RL.RackLotGUID

		LEFT JOIN dbo.Reagent R ON 

			RL.ReagentGUID = R.ReagentGUID

		JOIN dbo.OrderableTest OT ON 

			BTT.OrderableTestID = OT.OrderableTestID
		
		LEFT JOIN dbo.PendingBloodUnitTest PBUT ON
			
			BUT.BloodUnitTestGuid = PBUT.BloodUnitTestGuid

	WHERE

		BUT.DivisionCode = @divisioncode

	AND	BUT.BloodUnitGUID = @bloodunitguid

	AND	BUT.RecordStatusCode = 'A'

	AND	(	(	AUT.RecordStatusCode IS NULL	) OR
			(	AUT.RecordStatusCode = 'A'	)
		)

	AND	(	(	RL.RecordStatusCode IS NULL	) OR
			(	RL.RecordStatusCode = 'A'	)
		)

	AND	(	(	R.RecordStatusCode IS NULL	) OR
			(	R.RecordStatusCode = 'A'	)
		)

	AND	RL.ControlCellID IS NULL

	AND OT.OrderableTestName NOT LIKE 'Repeat%'

	AND OT.ReagentTypeId IS NOT NULL

	ORDER BY

		ISNULL(PBUT.UnitResultSetGuid, BUT.AntiseraWorklistTypingGuid) ASC,
		OT.OrderableTestID ASC, 
		BUT.TestDate DESC
		
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodUnitTestingWorklist]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodUnitTestingWorklist]
GO

/****** Object:  StoredProcedure [dbo].[spGetBloodUnitTestingWorklist]    Script Date: 3/24/2016 8:56:48 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc:	Get results of all unit ABO/Rh and Antigen Typing tests for a given division and date range (BR_48.10)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/26/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/19/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/15/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; renamed parameter to be consistent with 
**					database standards (all lower case); changed formatting slightly for readability
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/12/2005	C. Taylor	CR 1141: Added Lot Number to TestedWith column for AG Typings.
**						Changed to use vw_ActiveAndInactiveBloodUnits view otherwise joins may fail when run historically.
**	01/17/2006	C. Taylor	Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (DR 1729)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**  05/18/2012  Lohse		**SQL 2008 Upgrade** - Ln121 - removing alias from ORDER BY clauses
**	01/18/2015	K. Dobranowski	Added AutoInstrumentComments (Defect 251282)
**	01/22/2015	K. Dobranowski	Added UnitResultSetGuid (Defect 251282)
**	02/04/2016	K. Dobranowski	Added ReviewUser (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/23/2016	K. Dobranowski Removed CAST from BUT.TestComments. Added error handling (Defect 286179)
**	03/31/2016	R. Sankala	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestingWorklist]
(
	@startdate			DATETIME,
	@enddate			DATETIME,
	@divisioncode		CHAR(5)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
--Convert the start and end date to UTC 
SET @StartDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate) 
SET @EndDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate) 

SELECT DISTINCT
	2 AS TestingWorklistReportType,
	BUT.BloodUnitGuid,
	BUT.BloodUnitTestGuid,
	ISNULL(BUT.AntiseraWorklistTypingGuid,BUT.ConfirmationWorklistUnitGuid) AS BloodUnitTestId,
--Test Performed
	OT.OrderableTestID,
	OT.OrderableTestText as OrderableTestName,
--Unit ID and Product COde
	BU.EyeReadableUnitID,
	BU.UnitProductCode,
	CASE BU.LabelTypeCode
		WHEN 'I' THEN BU.ProductShortName+', '+BU.UnitProductCode + BU.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
		ELSE BU.ProductShortName+', '+BU.UnitProductCode
	END AS ProductShortName, 
	BU.UnitDivisionId,
--Testing Method
	BUT.TestingMethodCode,
	TM.TestingMethodText,
--Rack (if applicable)
	RCK.RackName,
--Tested With
	CASE ISNULL(TWR.LotNumber,'')
	WHEN '' THEN
		BTT.TestedWith
	ELSE
		BTT.TestedWith + ', ' + TWR.LotNumber
	END AS TestedWith,
	BTT.BloodTestTypeId,
	BTT.BloodTestName,
	BTT.SortColumn,
--Phase
	BTT.Phase,
--Reaction Result
	BUT.TestResultId,
	TR.TestResultText,
--Testing Tech
	BUT.TestTechID,
	ISNULL(TU.UserName,BUT.TestTechID) as TestTechName,
--Date Tested
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) as TestDate,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 BloodUnitTest.TestDate FROM dbo.BloodUnitTest WHERE ISNULL(BloodUnitTest.AntiseraWorklistTypingGUID,BloodUnitTest.ConfirmationWorklistUnitGuid) = ISNULL(BUT.AntiseraWorklistTypingGUID,BUT.ConfirmationWorklistUnitGuid) AND BloodUnitTest.BloodUnitGuid = BUT.BloodUnitGuid AND ISNULL(BloodUnitTest.InactivateDate,'1/1/2000') = ISNULL(BUT.InactivateDate,'1/1/2000') ORDER BY BloodUnitTest.TestDate DESC)) AS WorklistDate,
--Additional Info
	BUT.TestComments,
	BUT.AutoInstrumentName,
	BUT.RecordStatusCode,
	BUT.LastUpdateUser,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) AS LastUpdateDate, 
	ISNULL(IU.UserName,BUT.InactivateUser) AS InactivateUser,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS InactivateDate,
--	Instrument Comment
	PBUT.AutoInstrumentComments,
	PBUT.UnitResultSetGuid,
	LU.UserName AS ReviewUser

FROM
	dbo.BloodUnitTest BUT
	LEFT JOIN  dbo.vw_ActiveAndInactiveBloodUnits BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
	LEFT JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
	LEFT JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
	LEFT JOIN dbo.OrderableTest OT on OT.OrderableTestID = BTT.OrderableTestID
	LEFT JOIN dbo.TestingMethod TM ON BUT.TestingMethodCode = TM.TestingMethodCode
	LEFT JOIN dbo.Rack RCK on RCK.RackGUID = BUT.RackGUID
	LEFT JOIN dbo.VbecsUser IU ON BUT.InactivateUser = IU.VbecsUserId
	LEFT JOIN dbo.VbecsUser TU ON BUT.TestTechId = TU.VbecsUserId
	LEFT JOIN dbo.ConfirmationWorklistUnit CWU ON BUT.ConfirmationWorklistUnitGuid = CWU.ConfirmationWorklistUnitGuid
	LEFT JOIN dbo.RackLot TWRL ON TWRL.RackLotGuid = (SELECT TOP 1 RackLot.RackLotGuid 
								FROM dbo.RackLot
								JOIN dbo.AntiseraUnitTest ON AntiseraUnitTest.RackLotGuid = RackLot.RackLotGuid
								WHERE AntiseraUnitTest.AntiseraWorklistTypingGuid = BUT.AntiseraWorklistTypingGuid
								AND ((BUT.BloodTestTypeID NOT IN (28,29,30) AND RackLot.ControlCellId IS NULL) OR (BUT.BloodTestTypeID IN (28,29,30) AND RackLot.ControlCellId = 0))
								AND RackLot.LotVialNumber IS NULL
								AND RackLot.TestWithId IS NULL
								AND AntiseraUnitTest.RecordStatusCode = BUT.RecordStatusCode)
	LEFT JOIN dbo.Reagent TWR ON TWR.ReagentGuid = TWRL.ReagentGuid
	LEFT JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid
	LEFT JOIN	dbo.VbecsUser LU ON BUT.EntryTechId = LU.VbecsUserId

WHERE
	BUT.DivisionCode = @divisioncode
	AND	BUT.RecordStatusCode IN ('A', 'E','X')
	AND BUT.TestDate >= @startdate
	AND BUT.TestDate <= @enddate
	AND ((BUT.BloodTestTypeID > 200) OR (BUT.BloodTestTypeID in (15,16,17,18,19,20,21,28,29,30)))
ORDER BY
	OT.OrderableTestID, WorklistDate, BU.EyeReadableUnitID, BU.UnitProductCode, BU.UnitDivisionId, BUT.RecordStatusCode, BloodUnitTestId, BTT.SortColumn, BTT.Phase, TestDate, InactivateDate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInactivateAboRHConfirmationTests]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInactivateAboRHConfirmationTests]
GO

/****** Object:  StoredProcedure [dbo].[spInactivateAboRHConfirmationTests]    Script Date: 1/19/2016 10:08:59 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc: 	Inactivates Abo/Rh confirmation test results for a blood unit
**
**	Author:	Martin Tsotchev
**
**	Date: 	01/29/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/19/04	C. Taylor		Added InactivateDate and InactivateUser
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	01/10/05	D. Askew		Added @lastupdatedate
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Removed comments, Removed null
**	09/02/2005	Lohse		Changed comments field length from 255 to 510
**	05/25/2006	Lohse		Changing RecordStatusCode update value to 'X' from 'E' CR 1900
**	12/05/2006	Lohse		Changing RecordStatusCode update value to 'E' CR 2082 - yargh!
**	01/15/2016	K.Dobranowski	Modified WHERE clause to allow NULL in ConfirmationWorklistUnitGuid since tests from auto instrument don't have it.
**								Added UnitResultSetGuid for auto instrument tests (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInactivateAboRHConfirmationTests]
(
	@bloodunitguid			UNIQUEIDENTIFIER,
	@confirmationworklistunitguid	UNIQUEIDENTIFIER = NULL,
	@unitresultsetguid				UNIQUEIDENTIFIER = NULL,
	@comments			VARCHAR(510),
	@inactivatedate			DATETIME = NULL,
	@inactivateuser			VARCHAR(30) = NULL,
	@divisioncode			CHAR(5),
   	@lastupdateuser		VARCHAR(30),
   	@lastupdatefunctionid		INT,
	@rowversion			TIMESTAMP ,
	@lastupdatedate		DATETIME
)

AS

SET NOCOUNT ON

DECLARE @error INT
DECLARE @rowcount INT

	UPDATE
		BUT
	SET
		RecordStatusCode = 'E',
		TestComments = @comments,
		InactivateDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @inactivatedate),
		InactivateUser = @inactivateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionID = @lastupdatefunctionid

	FROM dbo.bloodunittest BUT

	LEFT JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

	WHERE

		BUT.DivisionCode = @divisioncode

	AND	BUT.BloodUnitGUID = @bloodunitguid

	--results from auto instrument don't have a ConfirmationWorklistUnitGuid
	AND	(
			(	BUT.ConfirmationWorklistUnitGuid IS NULL	) OR
			(	BUT.ConfirmationWorklistUnitGUID = @confirmationworklistunitguid	)
		)

	AND	(
			(	PBUT.UnitResultSetGuid IS NULL	) OR
			(	PBUT.UnitResultSetGuid = @unitresultsetguid	)
		)
	AND	BUT.BloodTestTypeID IN (15,16,17,18,19,20,21)

	AND 	BUT.[RowVersion]=@rowversion

	SELECT @error=@@ERROR, @rowcount=@@ROWCOUNT

	IF @error = 0 AND @rowcount <> 1 AND ( SELECT COUNT(1) FROM  dbo.BloodUnitTest WHERE [RowVersion] = @rowversion ) <> 1 

		RAISERROR(50001, 16, 127)

	IF @rowcount <> 1 AND @error=0
		SET @error = -1

SET NOCOUNT OFF

	RETURN (@error)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInactivateAntigenTypingTests]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInactivateAntigenTypingTests]
GO

/****** Object:  StoredProcedure [dbo].[spInactivateAntigenTypingTests]    Script Date: 2/1/2016 1:14:31 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Inactivates antigen typing test results for a blood unit
**
**	Author:	Martin Tsotchev
**
**	Date: 	01/29/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/19/04	C. Taylor		Added InactivateDate and InactivateUser
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	01/10/05	D. Askew		Added @lastupdatedate
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Removed comments, Removed null
**	09/02/2005	Lohse		Changed comments field length from 255 to 510
**	01/15/2016	K.Dobranowski	Modified WHERE clause to allow NULL in AntiseraWorklistTypingGuid since tests from auto instrument don't have it.
**								Added UnitResultSetGuid for auto instrument tests (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInactivateAntigenTypingTests]
(
	@bloodunitguid			UNIQUEIDENTIFIER,
	@antiseraworklisttypingguid	UNIQUEIDENTIFIER = NULL,
	@unitresultsetguid			UNIQUEIDENTIFIER = NULL,
	@orderabletestid		INT,
	@comments			VARCHAR(510),
	@inactivatedate			DATETIME = NULL,
	@inactivateuser			VARCHAR(30) = NULL,
	@divisioncode			CHAR(5),
   	@lastupdateuser		VARCHAR(30),
   	@lastupdatefunctionid		INT,
   	@rowversion			TIMESTAMP = NULL,
	@lastupdatedate		DATETIME
)

AS

SET NOCOUNT ON

DECLARE @error INT
DECLARE @rowcount INT

	UPDATE
		BUT
	SET
		RecordStatusCode = 'E',
		TestComments = @comments,
		InactivateDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @inactivatedate),
		InactivateUser = @inactivateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionID = @lastupdatefunctionid

	FROM dbo.BloodUnitTest BUT

	LEFT JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

	WHERE

			BUT.DivisionCode = @divisioncode
		AND	
			BUT.BloodUnitGUID = @bloodunitguid

			--results from auto instrument don't have a AntiseraWorklistTypingGuid
		AND	(
				(	BUT.AntiseraWorklistTypingGuid IS NULL	) OR
				(	BUT.AntiseraWorklistTypingGuid = @antiseraworklisttypingguid	)
			)

		AND	(
				(	PBUT.UnitResultSetGuid IS NULL	) OR
				(	PBUT.UnitResultSetGuid = @unitresultsetguid	)
			)
	
		AND
			BUT.[RowVersion]=@rowversion
	
	SELECT @error=@@ERROR, @rowcount=@@ROWCOUNT

	IF @error = 0 AND @rowcount <> 1 AND ( SELECT COUNT(1) FROM  dbo.BloodUnitTest WHERE [RowVersion] = @rowversion ) <> 1 
		BEGIN

			RAISERROR(50001, 16, 127)

		END

	IF @rowcount <> 1 AND @error=0
		BEGIN

			SET @error = -1

		END

SET NOCOUNT OFF

	RETURN (@error)


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetBloodTestTypeMapping]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetBloodTestTypeMapping]
GO


/****** Object:  StoredProcedure [dbo].[spHL7GetBloodTestTypeMapping]    Script Date: 2/18/2016 3:32:26 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc:	Returns blood type test mapping information for the automated instrument interface (Defect 235352).
**
**	Author: Russell Stephenson
**
**	Date: 	1/21/2016
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	1/27/2016	Russell Stephenson   Defect 255352:  Add clause for rejecting Repeat orders for unit tests.
**	2/03/2016	Russell Stephenson   Defect 255352:  Added a condtion to allow NULL @orderabletestid to find the correct mapping and 
													Added Left Join and a check for orderable test name in last where clause.
**	02/18/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7GetBloodTestTypeMapping]
(
	@bloodtestpanelname	VARCHAR(250),
	@bloodtestname	VARCHAR(250),
	@orderabletestid INT = NULL 
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

SELECT 
		BTTM.BloodTestTypeId, 
		BTTM.AntigenTestTypeId 
FROM 
		dbo.BloodTestTypeMapping BTTM 
		INNER JOIN dbo.BloodTestType BTT ON BTTM.BloodTestTypeId = BTT.BloodTestTypeId 
		LEFT JOIN dbo.OrderableTest OT ON ot.OrderableTestId = BTT.OrderableTestId 
WHERE 
		BTTM.BloodPanelName = @bloodtestpanelname COLLATE SQL_Latin1_General_CP1_CS_AS 
		AND BTTM.BloodTestName = @bloodtestname COLLATE SQL_Latin1_General_CP1_CS_AS 
		AND (@orderabletestid IS NULL OR BTT.OrderableTestId = @orderabletestid) 
		AND (@orderabletestid IS NOT NULL OR (OT.OrderableTestName IS NULL OR OT.OrderableTestName NOT LIKE '%Repeat%'))

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdatePendingSpecimenTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdatePendingSpecimenTest]
GO


/****** Object:  StoredProcedure [dbo].[spUpdatePendingSpecimenTest]    Script Date: 1/22/2016 1:27:05 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc:	Updates a single PendingSpecimenTest record (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	01/21/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	02/12/2016	K.Adu-Poku	Changed RejectComment to RejectionComment
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spUpdatePendingSpecimenTest]
(
    @pendingspecimentestid INT,
	@specimentestguid UNIQUEIDENTIFIER = NULL,
	@pendingteststatusid TINYINT,
	@rejectioncomment VARCHAR(510) = NULL,
	@lastupdatedate DATETIME,
    @lastupdateuser VARCHAR(30),
    @rowversion TIMESTAMP,
    @lastupdatefunctionid INT
)
AS

SET NOCOUNT ON

DECLARE @ERROR  INT
DECLARE @ROWCOUNT INT

	UPDATE 
		dbo.PendingSpecimenTest
	SET 
		PendingTestStatusId = @pendingteststatusid,
		SpecimenTestGuid = @specimentestguid,
		RejectionComment = @rejectioncomment,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		PendingSpecimenTestId = @pendingspecimentestid
		AND [RowVersion] = @rowversion

SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM dbo.PendingSpecimenTest  WHERE [RowVersion] = @rowversion ) <> 1 
	RAISERROR(50001, 16, 127)
ELSE
	IF (@ERROR = 0 AND @ROWCOUNT <> 1)            
		SET @ERROR = -1

SET NOCOUNT OFF
                                
RETURN (@ERROR)

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdateOrderedTestToPreviousTaskStatus]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdateOrderedTestToPreviousTaskStatus]
GO

/****** Object:  StoredProcedure [dbo].[spUpdateOrderedTestToPreviousTaskStatus]    Script Date: 2/11/2016 9:08:20 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Updates the OrderedTest's TaskStatus to it's previous value (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	1/25/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	---------------	----------		-----------------
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spUpdateOrderedTestToPreviousTaskStatus]
(
	@orderedtestguid		UNIQUEIDENTIFIER,
	@rowversion				TIMESTAMP,
	@lastupdateuser			VARCHAR(30),
	@lastupdatedate			DATETIME,
	@lastupdatefunctionid	INT
)
AS

SET NOCOUNT ON 

DECLARE	@ERROR	INT,
		@ROWCOUNT	INT
	
DECLARE @previoustaskstatuscode CHAR(1)

	SET @previoustaskstatuscode = (SELECT TOP 1 TaskStatusCode
								   FROM dbo.SynMirror_OrderedTest
								   WHERE OrderedTestGuid = @orderedtestguid
								   ORDER BY MirrorId DESC)
	-- If we didn't find a previous status we will default it to 'N' (new)
	SET @previoustaskstatuscode = COALESCE(@previoustaskstatuscode, 'N')

	UPDATE
		dbo.OrderedTest
	SET
		TaskStatusCode = @previoustaskstatuscode,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE
		OrderedTestGUID=@orderedtestguid
		AND	[RowVersion] = @rowversion


	SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

	IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM dbo.OrderedTest WHERE [RowVersion] = @rowversion ) <> 1 
		RAISERROR(50001, 16, 127)
	ELSE
		IF (@ERROR = 0 AND @ROWCOUNT <> 1)	
			SET @ERROR = -1

SET NOCOUNT OFF

RETURN @ERROR


GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetPendingBloodUnitTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetPendingBloodUnitTest]
GO


/****** Object:  StoredProcedure [dbo].[spHL7GetPendingBloodUnitTest]    Script Date: 3/24/2016 4:25:41 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc:	Returns record from PendingBloodUnitTest table (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	1/16/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name				Description													
**	1/25/2016	Russell Stephenson	Renamed to spHL7GetPendingBloodUnitTest for HL7AIParser (Defect 235352).
**	1/27/2016	Russell Stephenson	Changed TINYINT to INT for @bloodtesttypeid (Defect 235352).
**	2/16/2016	K.Adu-Poku		Changed RejectComment to RejectionComment
**	2/17/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	5/20/2016	Russell Stephenson	Defect 286186:	Added error handling and return and corrected TestDate.
**	5/23/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spHL7GetPendingBloodUnitTest]
(
	@bloodunitid VARCHAR(13),
	@divisioncode CHAR(5),
	@pendingteststatusid TINYINT,
	@bloodtesttypeid INT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT
		PBUT.PendingBloodUnitTestId,
		PBUT.BloodUnitTestGuid,
		PBUT.BloodUnitGuid,
		PBUT.BloodTestTypeId,
		PBUT.BloodUnitId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PBUT.TestDate) AS TestDate,
		PBUT.TestTechId,
		PBUT.TestResultId, 
		PBUT.AutoInstrumentComments,
		PBUT.OrderedTestGuid,
		PBUT.OrderedComponentGuid,
		PBUT.AutoInstrumentName,
		PBUT.DivisionCode,
		PBUT.PendingTestStatusId,
		PBUT.RejectionComment,
		PBUT.UnitResultSetGuid, 
		PBUT.LastUpdateUser
	  FROM 
	  
		dbo.PendingBloodUnitTest PBUT

	  WHERE 
		PBUT.BloodUnitId = @bloodunitid
	    
		AND DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

		AND PBUT.BloodTestTypeId = @bloodtesttypeid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPoolCounter]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPoolCounter]
GO

/****** Object:  StoredProcedure [dbo].[spGetPoolCounter]    Script Date: 1/29/2016 10:26:32 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc:	Gets the Pool Counter Ids for a given division/year/recordstatus
**
**	Author:	Greg  Lohse
**
**	Date: 	07/20/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	07/20/2005	Lohse		Initial Draft.  Passing in @recordstatuscode of X allows us to see the highest picked
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Placed rowversion in square brackets, capitalized null, spaced out SQL, added @ERROR variable
**	04/05/2006	Lohse		Removing LastUpdateDate - unused
**	09/11/2013	Lohse		CR3320 - updated to return the A and top 1 X row
**	10/03/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/27/2014	Lohse		CR3404 fix - second query changed to pull back the maximum CounterValue record
**	04/07/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	01/29/2016	Lohse		Defect 251417 - changing VBECSLockingGuid to VBECSLockingId
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetPoolCounter]
(
	@divisioncode		CHAR(5),
	@counteryear		CHAR(2)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

			SELECT 

				pc.PoolCounterGuid,
				pc.CounterValue,
				pc.RecordStatusCode,
				pc.LastUpdateFunctionId,
				pc.[RowVersion],
				vl.VbecsLockId		-- no longer a Guid

			FROM

				dbo.PoolCounter pc
			LEFT OUTER JOIN VbecsLock vl ON vl.LockedRecordGuid = pc.PoolCounterGuid
			WHERE

				pc.DivisionCode = @divisioncode
			AND	pc.CounterYear = @counteryear
			AND	pc.RecordStatusCode = 'A'
		
UNION
			SELECT 

				A.PoolCounterGuid,
				A.CounterValue,
				A.RecordStatusCode,
				A.LastUpdateFunctionId,
				A.[RowVersion],
				NULL AS VbecsLockId

			FROM
				(SELECT TOP 1

						PoolCounterGuid,
						CounterValue,
						RecordStatusCode,
						LastUpdateFunctionId,
						[RowVersion]
			FROM
						dbo.PoolCounter
			WHERE
						DivisionCode = @divisioncode
					AND	CounterYear = @counteryear
					AND	RecordStatusCode = 'X'
					ORDER BY CounterValue DESC
				) A

			
SET @ERROR = @@ERROR

	
SET NOCOUNT OFF

RETURN(@ERROR)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInsertVbecsLock]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInsertVbecsLock]
GO


/****** Object:  StoredProcedure [dbo].[spInsertVbecsLock]    Script Date: 5/9/2016 12:57:12 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/********************************************************************************************************************************
**
**	Desc: 	Check is incoming record is locked, if not, create a new lock. 
**
**	Logic: 
**			Check if the @lockedrecordguid is on the VbecsLock table (SECTION I)
**			IF no record found, proceed to section 2, otherwise delete it if it's "expired"
**			Check if the @lockedrecordguid is on the PendingBloodUnitTest or PendingSpecimenTest tables (SECTION II)
**			If no conflicts were found, create a new lock (Insert into VbecsLock)
**			Return all information
**----------------------------------------------------------------------------------------------------------------------------
**	NOTE:	This sproc is NOT used by UC_114 (when the pending tests are inserted)
**			UC_114 uses spIsPendingBloodUnitTestLocked and spIsPendingSpecimenTestLocked
**----------------------------------------------------------------------------------------------------------------------------
**
**	Author:	Greg Lohse
**
**	Date: 	11/20/2012
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Description
** 	------		---------		--------------------
**	03/12/2013	Lohse			Rework for .NET upgrade
**	09/12/2013	Lohse			CR3311 - removing bad logic (@multidivisionindicator = 0 AND MultiDivisionIndicator = 1)
**								adding @lockinactivitytimeoutmin for performance gains
**	10/01/2013	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	02/20/2014	Lohse			Changing @lockinactivitytimeoutmin to 15 (VBECS default) CR3409
**	03/28/2014	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	02/16/2016	Lohse			Defect 251417 - adding new PendingTest logic for Automated Instruments. Cleanup format.
**	02/18/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	05/08/2016	Lohse			Defect 282342. Updating UC checking in section 2. Formatting tweaks, added more comments.
**	05/10/2016	P. Sanchez		** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInsertVbecsLock]
(
	@lockedrecordguid			UNIQUEIDENTIFIER = NULL,
	@lockedusecaseid			INT = NULL,
	@lockedformid				INT,
	@baselockedformid			INT,
	@lockfunctionid				INT,
	@lastupdateuser				VARCHAR(30),
	@lastupdatefunctionid		INT,
	@lockinactivitytimeoutmin	INT = 15,	--defaulted for MUCs where there is no division tie-in
	@divisioncode				CHAR(5),	--needed for full UC locks (could be null during MUC/HL7 locking)
	@sessionguid				UNIQUEIDENTIFIER,
	@multidivisionindicator		BIT = 0
)

AS

	SET NOCOUNT ON 

	BEGIN TRANSACTION

	DECLARE @remaininglocktime 		INT	--How much time does the record have left to be locked?
	SET @remaininglocktime = 0

	DECLARE @lockconflictindicator	INT --Was there an existing lock out there (by same or different user)
	SET @lockconflictindicator = 0

	DECLARE @existinglocktime		INT	--Time that an existing lock (if any) has been active on the database
	SET @existinglocktime = 0

	DECLARE @rowcount 				INT
	DECLARE @vbecslockid			INT	--Current VbecsLockId - used to delete expired lock records

	DECLARE @conflictcontext		VARCHAR(15)	--Used to store a UnitId or SpecimenUID if a lock conflict is found
	DECLARE @lastupdatedate			DATETIME	--time a conflicting lock was created , or if not conflict, the current time
	SET @lastupdatedate = ISNULL((dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, GETUTCDATE())), GETUTCDATE())		--initialize the value
	/*********************************************************************************************************************
							
											SECTION I - Check VbecsLock table

	*********************************************************************************************************************/

	/*Since LockedUseCaseId can be used with or without a LockedRecordGuid, I made 2 separate queries for readability*/	
	IF @lockedusecaseid IS NOT NULL
	    
		SELECT
				@vbecslockid = VbecsLockId, 
				@lockedformid = LockedFormId, 
				@baselockedformid = BaseLockedFormId,
				@lastupdatedate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastUpdateDate),
				@lastupdateuser = LastUpdateUser,
				@lastupdatefunctionid = LastUpdateFunctionId,
				@sessionguid = SessionGuid,
				@existinglocktime = DATEDIFF(mi, LastUpdateDate, GETUTCDATE())
		FROM 	
				dbo.VbecsLock 
		WHERE
				LockedUseCaseId = @lockedusecaseid 
		AND		((@multidivisionindicator = 0 AND DivisionCode = @divisioncode) OR (@multidivisionindicator = 1))
		AND		((@lockedrecordguid IS NULL) OR (@lockedrecordguid IS NOT NULL AND LockedRecordGuid = @lockedrecordguid))

	ELSE
		/*	Check for the LockedRecordGuid	*/
	    SELECT	
				@vbecslockid = VbecsLockId, 
				@lockedformid = LockedFormId, 
				@baselockedformid = BaseLockedFormId,
				@lastupdatedate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastUpdateDate),
				@lastupdateuser = LastUpdateUser,
				@lastupdatefunctionid = LastUpdateFunctionId,
				@sessionguid = SessionGuid,
				@existinglocktime = DATEDIFF(mi, LastUpdateDate, GETUTCDATE())
		FROM 	
				dbo.VbecsLock 
		WHERE  
				LockedRecordGuid = @lockedrecordguid
		AND		((@multidivisionindicator = 0 AND DivisionCode = @divisioncode) OR (@multidivisionindicator = 1))
		AND		LockedUseCaseId IS NULL	--UseCaseLocks only affect UseCaseLocks (or else add more specific logic here)


	SET @rowcount = @@ROWCOUNT		--@@ROWCOUNT changes with every SQL statement, so we save it off
	SET @remaininglocktime = @lockinactivitytimeoutmin - @existinglocktime		--calculate how many minutes are remaining on the lock

	
	/*-----------------------------------------------------------------------------------------------------------------
		If we have a @rowcount we have a lock!!
		Delete the lock if it's 60mins old (we're assuming it's a orphan record), and now we'll let this request make a new lock.
		If the lock is less than 60mins old, set the @lockconflictindicator (GlobalConfig someday? or meh?)
	------------------------------------------------------------------------------------------------------------------*/
	IF @rowcount > 0
	BEGIN
		IF @remaininglocktime < -60
			DELETE FROM dbo.VbecsLock WHERE VbecsLockId = @vbecslockid
		ELSE
			SET @lockconflictindicator = 1
	END


	/*********************************************************************************************************************
							
											SECTION II - Check Pending Test tables

	*********************************************************************************************************************/
	ELSE	-- @rowcount is zero
	BEGIN
			
			
			/*--------------------------------------------------------------------------------------------
				Check the PendingBloodUnitTest table
				Our most likely lock is the BloodUnitStatus lock, so start with that one
				The LockFunctionId isn't always 1-to-1. For example, UC_52 uses LockFunction = 56
				These functions are in the BloodUnitStatus row from the Locking SDD (UC_114 section)
				994=Mark Presumed Transfused, 997=DSSExtract (see VbecsLockFunction table)
			--------------------------------------------------------------------------------------------*/
			IF @lockfunctionid IN (2,3,11,13,24,25,26,27,41,43,59,69,70,73,994,997)
			BEGIN
				--BloodUnitStatus check 1 : check the BloodUnitStatusGuid
				SELECT 
						TOP 1 @conflictcontext = pbut.BloodUnitId
				FROM 
						dbo.BloodUnitStatus bus
						JOIN dbo.PendingBloodUnitTest pbut ON pbut.BloodUnitGuid = bus.BloodUnitGUID 
				WHERE
						bus.BloodUnitStatusGuid = @lockedrecordguid
				AND		pbut.PendingTestStatusId = 1 
 
				IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 2	--Conflict! BloodUnitStatus (by Guid)

				/*--------------------------------------------------------------------------------------------
					PendingBloodUnitTest may only have a BloodUnitId (non specific BloodUnit)
					So, if we didnt' find a record by BloodUnitStatusGuid, check by BloodUnitId.
					When this happens, its possible the PendingBloodUnitTest table is locking several units
				--------------------------------------------------------------------------------------------*/
				IF @lockconflictindicator = 0 
				BEGIN
					--BloodUnitStatus check 2 : check by BloodUnitId (pending tests may only have a UnitId)
					SELECT 
							TOP 1 @conflictcontext = bu.LabelUnitId
					FROM 
							dbo.BloodUnitStatus bus
							JOIN dbo.BloodUnit bu ON bu.BloodUnitGUID = bus.BloodUnitGuid 
							JOIN dbo.PendingBloodUnitTest pbut ON pbut.BloodUnitId = bu.LabelUnitId
					WHERE 
							bus.BloodUnitStatusGuid = @lockedrecordguid
					AND		pbut.PendingTestStatusId = 1
					AND		pbut.BloodUnitGuid IS NULL
					AND		bu.DivisionCode = pbut.DivisionCode		--in case unit ids aren't unique to a division

					IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 3	--Conflict! BloodUnitStatus (by ID)

				END
			END

			
			/*--------------------------------------------------------------------------------------------
				Check the PendingSpecimenTest table (assuming the @lockedRecordGuid is an OrderedTestGuid)
				Start with the OrderedTest lock check. LockFucntionId 995 = ExpireOrderedTests
			--------------------------------------------------------------------------------------------*/
			IF @lockfunctionid IN (56,92,995)  AND @lockconflictindicator = 0
			BEGIN
				SELECT 
						TOP 1 @conflictcontext = ps.SpecimenUid
				FROM 
						dbo.PendingSpecimenTest pst 
						JOIN dbo.PatientSpecimen ps ON pst.PatientSpecimenGuid = ps.PatientSpecimenGuid 
				WHERE 
						pst.OrderedTestGuid = @lockedrecordguid
				AND		pst.PendingTestStatusId = 1

				IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 7	--Conflict! OrderedTest (on PST)

				/*--------------------------------------------------------------------------------------------
					Repeat XM tests lock OrderedTest and will be found on the PendingBloodUnitTest table
				--------------------------------------------------------------------------------------------*/
				IF @lockconflictindicator = 0 
				BEGIN
					SELECT 
							TOP 1 @conflictcontext = ps.SpecimenUid
					FROM 
							dbo.PendingBloodUnitTest pbut 
							JOIN dbo.OrderedTest ot ON pbut.OrderedTestGuid = ot.OrderedTestGuid
							JOIN dbo.PatientSpecimen ps ON ot.PatientSpecimenGuid = ps.PatientSpecimenGuid 
					WHERE 
							pbut.OrderedTestGuid = @lockedrecordguid
					AND		pbut.PendingTestStatusId = 1

					IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 7	--Conflict! OrderedTest (on PBT)

				END
			END


			/*--------------------------------------------------------------------------------------------
				Back to checking the BloodUnitTest table (assuming the @lockedRecordGuid is an OrderedUnitGuid)
				XM Tests
			--------------------------------------------------------------------------------------------*/
			IF @lockfunctionid IN (3,24,25,26,40,43,47,59,73,94) AND @lockconflictindicator = 0
			BEGIN
				--OrderedUnit check 1 : check for pending tests when the BloodUnit is known
				SELECT 
						TOP 1 @conflictcontext = pbut.BloodUnitId
				FROM 
						dbo.PendingBloodUnitTest pbut
				WHERE
						pbut.OrderedUnitGuid = @lockedrecordguid
				AND		pbut.PendingTestStatusId = 1 
 
				IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 4	--Conflict! OrderedUnit (single unit)

				/*--------------------------------------------------------------------------------------------
					PendingBloodUnitTest may only have a BloodUnitId (non specific BloodUnit)
					When this happens, its possible the PendingBloodUnitTest table is locking several units
				--------------------------------------------------------------------------------------------*/
				IF @lockconflictindicator = 0
				BEGIN
					--OrderedUnit check 2 : check by BloodUnitId (pending tests may only have a UnitId)
					SELECT 
							TOP 1 @conflictcontext = bu.LabelUnitId
					FROM 
							dbo.OrderedUnit ou
							JOIN dbo.BloodUnit bu ON ou.BloodUnitGUID = bu.BloodUnitGuid 
							JOIN dbo.PendingBloodUnitTest pbut ON bu.LabelUnitId = pbut.BloodUnitId
					WHERE 
							ou.OrderedUnitGuid = @lockedrecordguid
					AND		pbut.PendingTestStatusId = 1 
					AND		pbut.BloodUnitGuid IS NULL 	
					AND		bu.DivisionCode = pbut.DivisionCode			--in case unit ids aren't unique to a division
				END

				IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 5	--Conflict! OrderedUnit (by UnitId)
			END

			/*--------------------------------------------------------------------------------------------
				Back to PendingSpecimenTest check (assuming the @lockedrecordguid IS PatientSpecimenGuid)
			--------------------------------------------------------------------------------------------*/
			IF @lockfunctionid IN (21,35,43,73,94) AND @lockconflictindicator = 0
			BEGIN
				SELECT 
						TOP 1 @conflictcontext = ps.SpecimenUid
				FROM 
						dbo.PatientSpecimen ps
						JOIN dbo.PendingSpecimenTest pst ON ps.PatientSpecimenGuid = pst.PatientSpecimenGuid
				WHERE 
						ps.PatientSpecimenGuid = @lockedrecordguid
				AND		pst.PendingTestStatusId = 1
				
				IF @conflictcontext IS NOT NULL SET @lockconflictindicator = 6	--Conflict! PatientSpecimen
			END
	END --(@rowcount > 0)

	
	/*********************************************************************************************************************
			WE'VE DONE ALL OUR LOCK CHECKS, SO IF WE DON'T HAVE A CONFLICT, CREATE THE NEW LOCK RECORD
			
			IF WE FOUND A CONFLICT - RETURN THE CONFLICT INFORMATION COLLECTED SO IT CAN BE DISPLAYED TO THE USER
	*********************************************************************************************************************/	
	IF @lockconflictindicator = 0 AND @@ERROR = 0 
	  BEGIN
		INSERT INTO dbo.VbecsLock
		(
			LockedRecordGuid,		LockedUseCaseId,			LockedFormId,
			BaseLockedFormId,		LockFunctionID,				DivisionCode,
			LastUpdateDate,			LastUpdateUser,				LastUpdateFunctionId,
			SessionGuid,			MultiDivisionIndicator
		)
		VALUES
		(
			@lockedrecordguid,		@lockedusecaseid,			@lockedformid,
			@baselockedformid,		@lockfunctionid,			@divisioncode,
			GETUTCDATE(),			@lastupdateuser,			@lastupdatefunctionid,
			@sessionguid,			@multidivisionindicator
		)

	  END

	
	/*--------------------------------------------------------------------------------------------
		Everything has worked so far, so return everything back for display (on conflicts)
	--------------------------------------------------------------------------------------------*/
	IF @@ERROR = 0
		BEGIN
			COMMIT TRANSACTION
			
			SELECT
				@lockedrecordguid			AS LockedRecordGuid,
				@lockedusecaseid			AS LockedUseCaseId,
				@lockedformid				AS LockedFormId,
				@baselockedformid			AS BaseLockedFormId,
				@lockfunctionid				AS LockFunctionID,
				@lastupdatedate				AS LastUpdateDate,
				@divisioncode				AS DivisionCode, 
				@lastupdateuser				AS LastUpdateUser,
				@lastupdatefunctionid		AS LastUpdateFunctionId,
				@lockconflictindicator		AS LockConflictIndicator,	--Fieldname tied to DataBaseConstants class
				@remaininglocktime			AS RemainingLockTime,		--Fieldname tied to DataBaseConstants class
				@multidivisionindicator		AS MultiDivisionIndicator,
				@sessionguid				AS SessionGuid,
				ISNULL(@conflictcontext,'') AS ConflictContext			--SpecimenUID or UnitID (pending test found)
		END
	ELSE	-- the Insert failed
		ROLLBACK TRANSACTION		--DO WE NEED A TRANSACTION?
		
SET NOCOUNT OFF 

RETURN(@lockconflictindicator)		--0 = none, otherwise some number. Affects batch jobs if changed!





GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetTestingTaskList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetTestingTaskList]
GO


/****** Object:  StoredProcedure [dbo].[spGetTestingTaskList]    Script Date: 1/29/2016 10:54:33 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Get the list of pending tasks
**
**	Author: 	Krzysztof Dobranowski
**
**	Date: 	04/23/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		-----------------
**	04/23/2003	K. Dobranowski	Initial creation.
**	07/01/2003	M.Jablonski 	Added 4 fields: PatientOrderGUID, OrderReceivedDatetime, OrderingProvideMiddleInitial & PatientLocation
**	01/13/2004	C Taylor		Added DisplayVistaPatientId
**	02/24/2004	M.Jablonski	Added PatientTreatment.PatientTreatmentGUID to SELECT	
**	02/25/04	C. Taylor	Removed ExtendedExpirationDate - no longer needed (use mirror tables to see original expiration date)
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	04/23/2004	C.Taylor		Added TaskStatus of 'R' to WHERE clause
**	05/05/2004	C. Taylor	Replaced SpecimenAccessionNumber with Specimenuid
**	06/15/2004	C. Taylor	Replaced PatientGuid join with function fnGetPatientGuid to ensure latest patient details returned
**	06/28/2004	C. Taylor	Added preSpecimenGuid for UC_21
**	07/01/2004	C. Jensen	Added SpecimenAccessionNumber and LabTestId
**	01/06/2004	C. Taylor	Added OrderGroupNumber
**	07/07/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name, input/output from comment header, Added NOCOUNT, Specified table owners, 
**					spaced out SQL
**	09/09/2005	D. Askew	Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**					merges (choosing the final merge record) or simply the patient guid if there are none
**	09/29/2005	K. Dobranowski	Changed the expiration date to be 10 days not 3 days from Order Received date per CR 1164
**	01/18/2006	C. Taylor	Removed PreSpecimenGuid (CR 1462)
**	01/23/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	11/10/2009	K. Dobranowski	Removed check for expiration date from WHERE clause (CR 2368)
**	01/29/2016	K. Dobranowski	Added TaskStatuCode of 'A' to WHERE clause to accomodate new automated instrument status (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetTestingTaskList]
(
	@divisioncode		VARCHAR(5),
	@ordergroupnumber 	VARCHAR(20) = NULL
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		
		dbo.OrderUrgency.OrderUrgencyText,
		dbo.OrderedTest.OrderedTestGUID,
		dbo.OrderedTest.OrderUrgencyCode,
		dbo.OrderedTest.OrderedTestComments,
		dbo.OrderedTest.CprsOrderNumber,
		dbo.OrderedTest.OrderableTestID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.OrderedTest.RequiredResultsDate) AS  RequiredResultsDate,

		dbo.OrderedTest.TaskStatusCode,
		dbo.OrderedTest.RelatedTestGUID,
		dbo.OrderedTest.RelatedComponentGUID,
		dbo.OrderedTest.SpecimenAccessionNumber,
		dbo.OrderedTest.LabTestId,
		dbo.OrderedTest.LastUpdateUser,
		dbo.OrderedTest.[RowVersion],
		dbo.PatientTreatment.PatientGUID,
		dbo.Patient.PatientFirstName,
		dbo.Patient.PatientLastName,
		dbo.Patient.PatientMiddleName,
		dbo.Patient.VistaPatientID,
		dbo.Patient.PatientSSN,
		dbo.Patient.DisplayVistaPatientId,
		dbo.PatientTreatment.PatientLocation,
		dbo.PatientTreatment.PatientTreatmentGUID,
		dbo.Patient.BloodTypeCode,
		dbo.Patient.RhFactorCode,
		dbo.PatientOrder.PatientOrderGUID,
		dbo.PatientOrder.OrderingProviderFirstName,
		dbo.PatientOrder.OrderingProviderLastName,
		dbo.PatientOrder.OrderingProviderMiddleInitial,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  dbo.PatientOrder.OrderPlacedDateTime) AS OrderPlacedDateTime,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.PatientOrder.OrderReceivedDatetime) AS OrderReceivedDatetime ,

		dbo.PatientSpecimen.PatientSpecimenGUID,
		dbo.PatientSpecimen.Specimenuid,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.PatientSpecimen.SpecimenExpirationDate) AS SpecimenExpirationDate,

		dbo.OrderableTest.OrderableTestName,
		dbo.TaskStatus.TaskStatusText,
		dbo.OrderUrgency.SortColumn,
		dbo.PatientOrder.OrderGroupNumber
	
	   FROM dbo.OrderedTest
	
		JOIN dbo.PatientOrder ON dbo.PatientOrder.PatientOrderGUID = dbo.OrderedTest.PatientOrderGUID
	
		LEFT JOIN dbo.OrderUrgency ON dbo.OrderUrgency.OrderUrgencyCode = dbo.OrderedTest.OrderUrgencyCode
	
		LEFT JOIN dbo.PatientTreatment ON dbo.PatientTreatment.PatientTreatmentGUID = dbo.PatientOrder.PatientTreatmentGUID
	
		LEFT JOIN dbo.Patient ON PatientTreatment.PatientGuid = COALESCE(dbo.Patient.FinalMergeToPatient, dbo.Patient.PatientGuid)
	
		LEFT JOIN dbo.PatientSpecimen ON dbo.PatientSpecimen.PatientSpecimenGUID = dbo.OrderedTest.PatientSpecimenGUID
	
		LEFT JOIN dbo.OrderableTest ON dbo.OrderableTest.OrderableTestID = dbo.OrderedTest.OrderableTestID
	
		LEFT JOIN dbo.TaskStatus ON dbo.TaskStatus.TaskStatusCode = dbo.OrderedTest.TaskStatusCode
	
	WHERE dbo.OrderedTest.DivisionCode = @divisioncode

		AND (@ordergroupnumber IS NOT NULL OR (dbo.OrderedTest.OrderStatusCode = 'A' AND dbo.OrderedTest.TaskStatusCode IN ('I','N','P','R','A')))

		/*if searching for ordergroupnumber include orders that are expired*/
		AND (@ordergroupnumber IS NULL OR (dbo.PatientOrder.OrderGroupNumber = @ordergroupnumber AND dbo.OrderedTest.TaskStatusCode IN ('I','N','P','R','E','A')))
	
	   ORDER BY dbo.OrderUrgency.SortColumn,
		         dbo.Patient.PatientLastName

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetDivisionWorkloadReport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetDivisionWorkloadReport]
GO

/****** Object:  StoredProcedure [dbo].[spGetDivisionWorkloadReport]    Script Date: 02/08/2016 8:38:53 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects all records from the Division Workload Report
**
**	Author: Carrie Van Stedum
**
**	Date: 	09/24/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	07/18/2005	D. Askew	** Reviewed for compliance with database standards and recommendations **
**							NO COUNT set ON/OFF; comments updated; capitalized SQL statements
**	01/11/2016	C. Van Stedum	Added WorkloadEventStatusText to Select and a JOIN to the WorkloadEventStatus table Defect 251270.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivisionWorkloadReport]
(
	@divisioncode		CHAR(5),
	@singledivision		BIT,
	@startdate		DATETIME,
	@enddate		DATETIME
)

AS

SET NOCOUNT ON

	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SELECT 
		vp.VbecsProcessName, 
		VP.TransactionType, 
		wp.WorkloadCode,
		we.DivisionCode,
		we.weightmultiplier,
		vd.DivisionName,
		wes.WorkloadEventStatusText
		
	FROM 
		dbo.WorkloadEvent we 

	LEFT JOIN dbo.WorkloadProcess wp 
		ON we.WorkloadProcessGuid = wp.WorkloadProcessGuid 
	JOIN dbo.WorkloadEventStatus wes 
		ON we.WorkloadEventStatusCode = wes.WorkloadEventStatusCode	
	LEFT JOIN dbo.VbecsProcess vp 
		ON wp.VbecsProcessId = vp.VbecsProcessId

	LEFT JOIN dbo.VamcDivision vd
		ON vd.DivisionCode = we.DivisionCode

	-- doing the or @divisioncode = null cause if they pass null I want data for all divisions
	WHERE ((@singledivision = 1 AND we.DivisionCode = @divisioncode) or  (@singledivision = 0))
	 AND we.WorkloadEventDate >= @startdate
	 AND we.WorkloadEventDate <= @enddate
 	 AND we.RecordStatusCode = 'A'
		
	ORDER BY VbecsProcessName

RETURN(@@ERROR)

SET NOCOUNT OFF

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAuditUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAuditUser]
GO

/****** Object:  StoredProcedure [dbo].[spGetAuditUser]    Script Date: 1/12/2016 10:59:28 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/********************************************************************************************************************************
**	Desc: 	Get User audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   06/22/2005
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Defect	Description
**	----------	---------		------	--------------------------------------------------------------
**	08/17/2005	N.Paterson				** Reviewed for compliance with database standards and recommendations **
**										Specified object owners, aliased Tables, spaced out SQL, placed input params in brackets, added error variable
**										Changed MirrorDate filter to use BETWEEN instead of => <=
**  12/29/2015	Lohse			251166	Adding VbecsUserGuid for sorting info (key field), adding UserName, changing sort order
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditUser]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	CHAR(5)
)
 AS

SET NOCOUNT ON

DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ON_ERROR

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ON_ERROR

SELECT

	VMU.VbecsUserGuid,		--added GL
	VMU.VbecsUserId,
	VMU.UserName,
	VMU.UserDUZ,
	VMU.VistaUserName,
	VMU.UserEmail,
	VMU.UserInitials,
	VMU.RecordStatusCode,
	VMU.MirrorId,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VMU.LastUpdateDate) AS MirrorDate,
	VMU.LastUpdateUser

FROM

	dbo.SynMirror_V_VbecsUser VMU

WHERE

	VMU.MirrorDate BETWEEN @startdate AND @enddate

ORDER BY

	VMU.VbecsUserGuid,		--changed (from VbecsUserId) to use the key field in DAL
	VMU.Source,
	VMU.MirrorId DESC

SET @ERROR = @@ERROR

ON_ERROR:

SET NOCOUNT OFF

RETURN (@ERROR)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAuditUserRole]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAuditUserRole]
GO

/****** Object:  StoredProcedure [dbo].[spGetAuditUserRole]    Script Date: 1/12/2016 11:13:22 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/********************************************************************************************************************************
**	Desc: 	Get User Role audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/17/2004
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Defect	Description
**	----------	---------		------	--------------------------------------------------------------
**	04/27/2004	M. Jablonski			Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson				** Reviewed for compliance with database standards and recommendations **
**										Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**										Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/19/2005	N.Paterson				Implemented differences between Review_Start and DEV before porting changes to DEV
**	12/29/2015	Lohse			251166	Adding VbecsUserGuid for sorting info (key field), adding UserName, changing sort order
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditUserRole]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	CHAR(5)
)
 AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT
		
		VU.VbecsUserGuid,
		VVUDR.UserRoleId,
		VVUDR.RecordStatusCode,
		VVUDR.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VVUDR.LastUpdateDate) AS MirrorDate,

		VVUDR.LastUpdateUser,
		VU.UserName,
		VU.VbecsUserId,
		UR.UserRoleName
	
	FROM

		dbo.SynMirror_V_VbecsUserDivisionRole VVUDR

	JOIN dbo.VbecsUser VU ON VU.VbecsUserId = VVUDR.VbecsUserId

	JOIN dbo.UserRole UR ON UR.UserRoleId = VVUDR.UserRoleId
	
	WHERE

		VVUDR.MirrorDate  BETWEEN @startdate  AND  @enddate

	AND

		VVUDR.DivisionCode = @divisioncode
	
	ORDER BY

		VU.VbecsUserGuid,	--changed (from VbecsUserId) to use the key field in DAL
		VVUDR.Source,
		VVUDR.MirrorId DESC


SET @ERROR = @@ERROR
	

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetOrderedUnitsForUnit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetOrderedUnitsForUnit]
GO

/****** Object:  StoredProcedure [dbo].[spGetOrderedUnitsForUnit]    Script Date: 1/12/2016 11:22:03 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects blood units that may be eligible for tag printing
**
**	Author: 	Carl Jensen
**	
**	Date: 	04/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	--------------	---------		------------------
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	02/27/2005	Lohse		FullProductCode was bombing due to MSmith DB Changes.  Fixed.
**	05/03/2005	Lohse		Added BiohazardousWarningIndicator to SELECT -- needed for SelectUnits grid population
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/20/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
							Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	07/21/2005	Lohse		ORDER BY EyeReadableUnitId, FullProductCode
**	08/21/2005	s. Antropov	** Reviewed for compliance with database standards and recommendations **
**							Performed secondary review during the code promotion, updated header comment, 
**							formatted SQL, merged changes, added SET NOCOUNT
**	01/04/16	C. Van Stedum	Defect 251360, added in patient name for displaying the restricted for patient
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetOrderedUnitsForUnit]
(
	@divisioncode 	CHAR(5)
)
AS
	SET NOCOUNT ON 

	DECLARE @error INT

	SELECT DISTINCT
		OU.BloodUnitGUID,
		VW.EyeReadableUnitID,
		VW.BloodProductGUID,
		VW.ProductShortName,
		VW.DonationTypeText,
		VW.QuarantineIndicator,
		VW.BiohazardousWarningIndicator,
		VW.LabelUnitID,
		VW.UnitProductCode,
		VW.ProductTypeCode,
		VW.ProductName,
		VW.RhFactorCode,
		VW.BloodTypeCode,
		RTRIM(VW.BloodTypeCode) + ' ' + VW.RhFactorText AS AboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VW.UnitInDate) AS UnitInDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VW.UnitExpirationDate) AS UnitExpirationDate,
		VW.UnitDivisionID,
		PT.PatientFirstName,
		PT.PatientLastName,
		PT.PatientMiddleName,
		VW.UnitStatusCode,
		VW.UnitStatusText,
		CASE VW.LabelTypeCode
			WHEN 'I' THEN VW.UnitProductCode + VW.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + VW.UnitDivisionId 
			ELSE VW.UnitProductCode
		END AS FullProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VW.ShipmentDate) AS ShipmentDate,
		VW.PresumedTransfusedIndicator
	FROM
		dbo.OrderedUnit OU
		JOIN dbo.vw_BloodShipAllCurrent  VW ON OU.BloodUnitGUID = VW.BloodUnitGUID
		LEFT JOIN dbo.Patient PT on PT.PatientGuid = VW.DirectedPatientGUID
	WHERE
		OU.RecordStatusCode = 'A' AND
		OU.DivisionCode = @divisioncode AND
		OU.ReleaseDate IS Null AND VW.UnitStatusCode IN ('S','C')
	ORDER BY EyeReadableUnitId, FullProductCode

	SET @error = @@ERROR

	SET NOCOUNT OFF

	RETURN @error


GO




USE @DBNAME@
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodUnitTestResultsForOrderedComponent]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodUnitTestResultsForOrderedComponent]
GO

/****** Object:  StoredProcedure [dbo].[spGetBloodUnitTestResultsForOrderedComponent]    Script Date: 2/11/2016 8:22:11 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc:	Gets test results for a given ordered component
**
**	Author:	Cameron Taylor
**
**	Date: 	04/09/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/17/2005	NPaterson	Use new view for increased performance
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	04/04/2006	Lohse		Adding DateTimeConversion to InactivateDate
**	01/31/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to allow invalidation logic to differentiate between automated and manual tests (Defect 251282)
**	02/10/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to the ELSE part of the stored procedure (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitTestResultsForOrderedComponent]
(
	@orderedcomponentguid	UNIQUEIDENTIFIER,
	@bloodunitguid			UNIQUEIDENTIFIER = NULL,
	@divisioncode			CHAR(5)
)
AS

DECLARE @ERROR INT

SET NOCOUNT OFF

IF @BloodUnitGUID IS NULL
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedComponentGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedComponent OC ON OC.OrderedComponentGUID = BUT.OrderedComponentGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID
		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		LEFT JOIN	dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid
		
		WHERE	BUT.OrderedComponentGUID = @orderedcomponentguid
		AND		BUT.RecordStatusCode = 'A'
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END
ELSE
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedComponentGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedComponent OC ON OC.OrderedComponentGUID = BUT.OrderedComponentGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID
		LEFT JOIN		dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		LEFT JOIN	dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		WHERE	BUT.OrderedComponentGUID = @orderedcomponentguid
		AND		BUT.BloodUnitGUID = @bloodunitguid
		AND		BUT.RecordStatusCode = 'A'
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END
		
SET NOCOUNT OFF

RETURN(@ERROR)


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodUnitTestResultsForOrderedTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodUnitTestResultsForOrderedTest]
GO

/****** Object:  StoredProcedure [dbo].[spGetBloodUnitTestResultsForOrderedTest]    Script Date: 2/11/2016 8:55:01 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc:	Gets test results for a given ordered test
**
**	Author:	Cameron Taylor
**
**	Date: 	04/09/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/17/2005	NPaterson	Changed to use new view for increased performance
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	04/04/2006	Lohse		Adding DateTimeConversion to InactivateDate
**	01/31/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to allow invalidation logic to differentiate between automated and manual tests (Defect 251282)
**	02/10/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to the ELSE part of the stored procedure (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestResultsForOrderedTest]
(
	@orderedtestguid	UNIQUEIDENTIFIER,
	@bloodunitguid		UNIQUEIDENTIFIER = NULL,
	@divisioncode		CHAR(5)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

IF @BloodUnitGUID IS NULL
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedTestGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID
		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid
		
		WHERE	BUT.OrderedTestGUID = @orderedtestguid
		AND		BUT.RecordStatusCode = 'A'
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END
ELSE
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedTestGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID
		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		WHERE	BUT.OrderedTestGUID = @orderedtestguid
		AND		BUT.BloodUnitGUID = @bloodunitguid
		AND		BUT.RecordStatusCode = 'A'
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END	

SET NOCOUNT OFF
	
RETURN(@ERROR)


GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPatientTestingWorklist]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPatientTestingWorklist]
GO

/****** Object:  StoredProcedure [dbo].[spGetPatientTestingWorklist]    Script Date: 3/24/2016 9:03:28 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc:	Get results of all patient specimen tests (except TRWs) for a given patient and division (BR_48.06)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/26/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/19/2004	M.Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	05/05/2004	C. Taylor	Replaced SpecimenAccessionNumber with Specimenuid
**	06/07/2004	C. Taylor	Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	06/08/2004	C. Taylor	Replaced PatientGuid join with function fnGetPatientGuid to ensure latest patient details returned
**	05/02/2005 	Lohse		Removed CannedCommentText from XM and RepeatXM queries - CannedCommentGuid was DROPPED 
**					from BUT table
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/06/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name from comment header, Added NOCOUNT, Specified table owners, 
**					spaced out SQL, use new views
**	07/25/2005	N.Paterson	Made join to Patient Inner Join from Left Join per MSmith
**	08/21/2005	S. Antropov	** Reviewed for compliance with database standards and recommendations **
**					Performed secondary review during the code promotion - merged changes
**	09/09/2005	D. Askew	Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**					merges (choosing the final merge record) or simply the patient guid if there are none;
**					removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/12/2005	C. Taylor	CR 1141: Added Lot Number to TestedWith column for DAT, ABSs and AG Typings.
**	01/17/2006	C. Taylor	Replaced ProductShortName with FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) for XM & Repeat XM (DR 1729)
**	01/23/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	05/18/2012	Lohse		**SQL 2008 Upgrade** - removing alias from ORDER BY clauses
**	01/29/2016	K. Dobranowski	Added AutoInstrumentComments (Defect 251282)
**	01/30/2016	K. Dobranowski	Added OrderedUnitGuid for crossmatch results (Defect 210502)
**	02/04/2016	K. Dobranowski	Added ResultSetGuid and ReviewUser (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/23/2016	K. Dobranowski	Removed CAST from BUT.TestComments and ST.TestComments. Added error handling.(Defect 286179)
**	03/31/2016	R. Sankala	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetPatientTestingWorklist]
(
		@patientguid		UNIQUEIDENTIFIER,
		@divisioncode		CHAR(5)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
-- Patient Testing from SpecimenTest
	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OT.OrderedTestGUID AS TestGUID,
		'0000000000000' + CONVERT(VARCHAR(40),OT.OrderedTestGUID) AS TestUnitId,
		NULL AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		BTT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		ST.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE BTT.OrderableTestID
		WHEN 1 THEN
			BTT.TestedWith
		WHEN 3 THEN
			BTT.TestedWith
		WHEN 111 THEN
			BTT.TestedWith
		WHEN 113 THEN
			BTT.TestedWith
		ELSE
			CASE ISNULL(TWR.LotNumber,'')
			WHEN '' THEN
				BTT.TestedWith
			ELSE
				BTT.TestedWith + ', ' + TWR.LotNumber
			END
		END	AS TestedWith,
	--Phase
		ST.BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		ST.TestResultID,
		TR.TestResultText,
		ANTI.AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 SpecimenTest.TestDate FROM dbo.SpecimenTest WHERE SpecimenTest.OrderedTestGuid = OT.OrderedTestGuid AND ISNULL(SpecimenTest.InactivateDate,'1/1/2000') = ISNULL(ST.InactivateDate,'1/1/2000') ORDER BY SpecimenTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		ST.TestComments,
		ST.AutoInstrumentName,
		ST.RecordStatusCode AS RecordStatusCode,
		ST.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.InactivateDate) AS InactivateDate,

		CC.CannedCommentText,
		ST.CorrectedResultIndicator,
		ST.OffsiteIndicator,
		ST.OffsiteLocation,
--	Instrument Comment
		PST.AutoInstrumentComments,
		NULL AS OrderedUnitGuid,
		PST.SpecimenResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser

	FROM dbo.SpecimenTest ST
	
	LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = ST.PatientSpecimenGUID

	LEFT JOIN	dbo.OrderedTest OT ON OT.OrderedTestGUID = ST.OrderedTestGUID

	LEFT JOIN	dbo.RackLot TWRL ON TWRL.RackLotGuid = (SELECT TOP 1 RackLot.RackLotGuid 
								FROM dbo.RackLot
								JOIN dbo.AntiseraOrderedTest ON AntiseraOrderedTest.RackLotGuid = RackLot.RackLotGuid
								WHERE AntiseraOrderedTest.OrderedTestGuid = OT.OrderedTestGuid
								AND RackLot.ControlCellId = 1
								AND RackLot.LotVialNumber IS NULL
								AND ((RackLot.RackGuid IS NULL) OR (RackLot.TestWithId IS NOT NULL))
								AND AntiseraOrderedTest.RecordStatusCode = ST.RecordStatusCode)

	LEFT JOIN	dbo.Reagent TWR ON TWR.ReagentGuid = TWRL.ReagentGuid
	
	LEFT JOIN	dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

	LEFT JOIN	dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

	INNER JOIN 	dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

	INNER JOIN 	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

	LEFT JOIN	dbo.BloodTestType BTT ON BTT.BloodTestTypeID = ST.BloodTestTypeID

	LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.OrderableTestID

	LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = ST.TestingMethodCode

	LEFT JOIN	dbo.AntibodyType ANTI ON ANTI.AntibodyTypeID = ST.AntibodyTypeID

	LEFT JOIN	dbo.Rack R ON R.RackGUID = ST.RackGUID

	LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = ST.TestResultID

	LEFT JOIN	dbo.CannedComment CC ON CC.CannedCommentGUID = ST.CannedCommentGUID

	JOIN		dbo.VbecsUser VU ON ST.TestTechID = VU.VbecsUserId

	LEFT JOIN	dbo.VbecsUser IU ON ST.InactivateUser = IU.VbecsUserId
	
	LEFT JOIN	dbo.PendingSpecimenTest PST ON PST.SpecimenTestGuid = ST.SpecimenTestGuid

	LEFT JOIN	dbo.VbecsUser LU ON ST.EntryTechId = LU.VbecsUserId

	WHERE	ST.DivisionCode = @divisioncode

	AND		P.PatientGUID IN
			(
				SELECT 
					P.PatientGuid
				FROM
					dbo.Patient P
				JOIN 
				    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
				WHERE
					LinkPatient.PatientGuid = @patientguid
			)

	AND		ST.RecordStatusCode IN ('A','E','X')

	AND		OT.OrderableTestID NOT IN (7,9,10,119) -- Don't include TASs (7), TRWs (10) or XMs (9,119)

UNION

-- TAS Testing from SpecimenTest

	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OT.OrderedTestGUID AS TestGUID,
		'0000000000000' + CONVERT(VARCHAR(40),OT.OrderedTestGUID) AS TestUnitId,
		NULL AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		OT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText + ' (' + REPTEST.OrderableTestText + ')' COLLATE SQL_Latin1_General_CP1_CS_AS AS OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		ST.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE ISNULL(BTT.ReportableTestId,0)
		WHEN 4 THEN
			CASE ISNULL(TWR.LotNumber,'')
			WHEN '' THEN
				BTT.TestedWith
			ELSE
				BTT.TestedWith + ', ' + TWR.LotNumber
			END
		ELSE
			BTT.TestedWith
		END	AS TestedWith,
	--Phase
		ST.BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		ST.TestResultID,
		TR.TestResultText,
		NULL AS AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 SpecimenTest.TestDate FROM dbo.SpecimenTest WHERE SpecimenTest.OrderedTestGuid = OT.OrderedTestGuid AND ISNULL(SpecimenTest.InactivateDate,'1/1/2000') = ISNULL(ST.InactivateDate,'1/1/2000') ORDER BY SpecimenTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		ST.TestComments,
		ST.AutoInstrumentName,
		ST.RecordStatusCode AS RecordStatusCode,
		ST.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.InactivateDate) AS InactivateDate,

		CC.CannedCommentText,
		ST.CorrectedResultIndicator,
		NULL AS  OffsiteIndicator,
		NULL AS OffsiteLocation,
	--	Instrument Comment
		PST.AutoInstrumentComments,
		NULL AS OrderedUnitGuid,
		PST.SpecimenResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser

	FROM dbo.SpecimenTest ST
	
	LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = ST.PatientSpecimenGUID

	LEFT JOIN	dbo.OrderedTest OT ON OT.OrderedTestGUID = ST.OrderedTestGUID

	LEFT JOIN	dbo.RackLot TWRL ON TWRL.RackLotGuid = (SELECT TOP 1 RackLot.RackLotGuid 
								FROM dbo.RackLot
								JOIN dbo.AntiseraOrderedTest ON AntiseraOrderedTest.RackLotGuid = RackLot.RackLotGuid
								WHERE AntiseraOrderedTest.OrderedTestGuid = OT.OrderedTestGuid
								AND RackLot.ControlCellId = 1
								AND RackLot.LotVialNumber IS NULL
								AND ((RackLot.RackGuid IS NULL) OR (RackLot.TestWithId IS NOT NULL))
								AND AntiseraOrderedTest.RecordStatusCode = ST.RecordStatusCode)

	LEFT JOIN	dbo.Reagent TWR ON TWR.ReagentGuid = TWRL.ReagentGuid

	LEFT JOIN	dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

	LEFT JOIN	dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

	LEFT JOIN 	dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

	LEFT JOIN 	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

	LEFT JOIN	dbo.BloodTestType BTT ON BTT.BloodTestTypeID = ST.BloodTestTypeID

	LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = OT.OrderableTestID

	LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = ST.TestingMethodCode

	LEFT JOIN	dbo.Rack R ON R.RackGUID = ST.RackGUID

	LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = ST.TestResultID

	LEFT JOIN	dbo.CannedComment CC ON CC.CannedCommentGUID = ST.CannedCommentGUID

	JOIN		dbo.VbecsUser VU ON ST.TestTechID = VU.VbecsUserId

	JOIN		dbo.OrderableTest REPTEST ON REPTEST.OrderableTestID = BTT.ReportableTestID

	LEFT JOIN	dbo.VbecsUser IU ON ST.InactivateUser = IU.VbecsUserId
	
	LEFT JOIN	dbo.PendingSpecimenTest PST ON PST.SpecimenTestGuid = ST.SpecimenTestGuid

	LEFT JOIN	dbo.VbecsUser LU ON ST.EntryTechId = LU.VbecsUserId

	WHERE	ST.DivisionCode = @divisioncode

	AND		P.PatientGUID IN 
			(
				SELECT 
					P.PatientGuid
				FROM
					dbo.Patient P
				JOIN 
				    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
				WHERE
					LinkPatient.PatientGuid = @patientguid
			)

	AND		ST.RecordStatusCode IN ('A','E','X')

	AND		OT.OrderableTestID = 7

UNION

-- XM Testing from OrderedComponent

	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OC.OrderedComponentGUID AS TestGUID,
		BU.EyeReadableUnitID + CONVERT(VARCHAR(40),OC.OrderedComponentGUID) AS TestUnitId,
		BU.EyeReadableUnitID AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		ORT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		BUT.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE BU.LabelTypeCode
			WHEN 'I' THEN BU.EyeReadableUnitID+', '+BU.UnitProductCode + BU.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
			ELSE BU.EyeReadableUnitID+', '+BU.UnitProductCode
		END AS TestedWith,
	--Phase
		BUT.BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		BUT.TestResultID,
		TR.TestResultText,
		NULL AS AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 BloodUnitTest.TestDate FROM dbo.BloodUnitTest WHERE BloodUnitTest.OrderedComponentGuid = OC.OrderedComponentGuid AND BloodUnitTest.BloodUnitGuid = BUT.BloodUnitGuid AND ISNULL(BloodUnitTest.InactivateDate,'1/1/2000') = ISNULL(BUT.InactivateDate,'1/1/2000') ORDER BY BloodUnitTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		BUT.TestComments,
		BUT.AutoInstrumentName,
		BUT.RecordStatusCode AS RecordStatusCode,
		BUT.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.InactivateDate) AS InactivateDate,

		NULL AS CannedCommentText,
		BUT.CorrectedResultIndicator,
		NULL AS OffsiteIndicator,
		NULL AS OffsiteLocation,
	--	Instrument Comment
		PBUT.AutoInstrumentComments,
		BUT.OrderedUnitGuid,
		PBUT.UnitResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser

	FROM
		dbo.BloodUnitTest BUT

		LEFT JOIN	dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID

		LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID

		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID

		JOIN		dbo.OrderedComponent OC ON OC.OrderedComponentGUID = BUT.OrderedComponentGUID

		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID

		LEFT JOIN	dbo.PatientOrder PO ON PO.PatientOrderGUID = OC.PatientOrderGUID

		LEFT JOIN	dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

		LEFT JOIN 	dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

		LEFT JOIN 	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.OrderableTestID

		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode

		JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId

		LEFT JOIN	dbo.VbecsUser IU ON BUT.InactivateUser = IU.VbecsUserId

		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID

		LEFT JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		LEFT JOIN	dbo.VbecsUser LU ON BUT.EntryTechId = LU.VbecsUserId

	WHERE

		BUT.DivisionCode = @divisioncode

		AND	BUT.RecordStatusCode IN ('A','E','X')

		AND BTT.OrderableTestID = 9 -- XM Tests only

		AND	P.PatientGUID IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

UNION

-- Repeat XM Testing from OrderedTest
	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OT.OrderedTestGUID AS TestGUID,
		BU.EyeReadableUnitID + CONVERT(VARCHAR(40),OT.OrderedTestGUID) AS TestUnitId,
		BU.EyeReadableUnitID AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		ORT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		BUT.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE BU.LabelTypeCode
			WHEN 'I' THEN BU.EyeReadableUnitID+', '+BU.UnitProductCode + BU.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
			ELSE BU.EyeReadableUnitID+', '+BU.UnitProductCode
		END AS TestedWith,
	--Phase
		BUT.BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		BUT.TestResultID,
		TR.TestResultText,
		NULL AS AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 BloodUnitTest.TestDate FROM dbo.BloodUnitTest WHERE BloodUnitTest.OrderedTestGuid = OT.OrderedTestGuid AND BloodUnitTest.BloodUnitGuid = BUT.BloodUnitGuid AND ISNULL(BloodUnitTest.InactivateDate,'1/1/2000') = ISNULL(BUT.InactivateDate,'1/1/2000') ORDER BY BloodUnitTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		BUT.TestComments,
		BUT.AutoInstrumentName,
		BUT.RecordStatusCode AS RecordStatusCode,
		BUT.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS InactivateDate,

		NULL AS CannedCommentText, 	-- CannedCommentGuid DROPPED from table
		BUT.CorrectedResultIndicator,
		NULL AS OffsiteIndicator,
		NULL AS OffsiteLocation,
		--	Instrument Comment
		PBUT.AutoInstrumentComments,
		BUT.OrderedUnitGuid,
		PBUT.UnitResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser

	FROM

		dbo.BloodUnitTest BUT

		LEFT JOIN	dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID

		LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID

		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID

		JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID

		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID

		LEFT JOIN	dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

		LEFT JOIN	dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

		LEFT JOIN 	dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid
		LEFT JOIN 	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.OrderableTestID

		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode

		JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId

		LEFT JOIN	dbo.VbecsUser IU ON BUT.InactivateUser = IU.VbecsUserId

		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID

		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		LEFT JOIN	dbo.VbecsUser LU ON BUT.EntryTechId = LU.VbecsUserId

	WHERE

		BUT.DivisionCode = @divisioncode

		AND	BUT.RecordStatusCode IN ('A','E','X')

		AND OT.OrderableTestID = 119 -- Repeat XM Tests only

		AND	P.PatientGUID IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

--BR_48.07
	ORDER BY 

	P.PatientLastName,
	P.PatientFirstName,
	P.PatientMiddleName,
	SpecimenCollectionDate,
	WorklistDate,
	TestUnitId,
	OrderableTestId,
	RecordStatusCode, 
	InactivateDate, 
	BTT.SortColumn, 
	TestDate, 
	R.RackName, 
	TestGUID

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPatientTestingWorklistByDates]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPatientTestingWorklistByDates]
GO



/****** Object:  StoredProcedure [dbo].[spGetPatientTestingWorklistByDates]    Script Date: 3/24/2016 9:06:18 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc:	Get results of all patient specimen tests (except TRWs) for a given division and date range (BR_48.06)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/26/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/19/2004	M.Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	05/05/2004	C. Taylor	Replaced SpecimenAccessionNumber with Specimenuid
**	06/08/2004	C. Taylor	Replaced PatientGuid join with function fnGetPatientGuid to ensure latest patient details returned
**	05/02/2005	Lohse		Removed CannedComment table join from XM and RepeatXM queries.  CannedCommentGuid was 
**					dropped from BUT table.
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/06/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name from comment header, Added NOCOUNT, Specified table owners, spaced out SQL, 
**					using new view
**	08/21/2005	S. Antropov	** Reviewed for compliance with database standards and recommendations **
**					Performed secondary review during the code promotion - merged changes
**	09/09/2005	D. Askew	Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**					merges (choosing the final merge record) or simply the patient guid if there are none
**	10/12/2005	C. Taylor	CR 1141: Added Lot Number to TestedWith column for DAT, ABSs and AG Typings.
**	01/17/2006	C. Taylor	Replaced ProductShortName with FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) for XM & Repeat XM (DR 1729)
**	01/23/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	05/18/2012	Lohse		**SQL 2008 Upgrade** - removing alias from ORDER BY clauses
**	01/29/2016	K. Dobranowski	Added AutoInstrumentComments (Defect 251282)
**	01/30/2016	K. Dobranowski	Added OrderedUnitGuid for crossmatch results (Defect 210502)
**	02/04/2016	K. Dobranowski	Added ResultSetGuid and ReviewUser (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/23/2016	K. Dobranowski	Removed CAST from BUT.TestComments and ST.TestComments. Added error handling. (Defect 286179)
**	03/31/2016	R. Sankala	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetPatientTestingWorklistByDates]
(
		@startdate		DATETIME,
		@enddate		DATETIME,
		@divisioncode	CHAR(5)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
--Convert the start and end date to UTC 
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate) 

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate) 


-- Patient Testing from SpecimenTest
	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OT.OrderedTestGUID AS TestGUID,
		'0000000000000' + CONVERT(VARCHAR(40),OT.OrderedTestGUID) AS TestUnitId,
		NULL AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		BTT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		ST.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE BTT.OrderableTestID
		WHEN 1 THEN
			BTT.TestedWith
		WHEN 3 THEN
			BTT.TestedWith
		WHEN 111 THEN
			BTT.TestedWith
		WHEN 113 THEN
			BTT.TestedWith
		ELSE
			CASE ISNULL(TWR.LotNumber,'')
			WHEN '' THEN
				BTT.TestedWith
			ELSE
				BTT.TestedWith + ', ' + TWR.LotNumber
			END
		END	AS TestedWith,
	--Phase
		ST.BloodTestTypeID AS BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		ST.TestResultID,
		TR.TestResultText,
		ANTI.AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 SpecimenTest.TestDate FROM dbo.SpecimenTest WHERE SpecimenTest.OrderedTestGuid = OT.OrderedTestGuid AND ISNULL(SpecimenTest.InactivateDate,'1/1/2000') = ISNULL(ST.InactivateDate,'1/1/2000') ORDER BY SpecimenTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		ST.TestComments,
		ST.AutoInstrumentName,
		ST.RecordStatusCode AS RecordStatusCode,
		ST.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.InactivateDate) AS InactivateDate,

		CC.CannedCommentText,
		ST.CorrectedResultIndicator,
		ST.OffsiteIndicator,
		ST.OffsiteLocation,
		--	Instrument Comment
		PST.AutoInstrumentComments,
		NULL AS OrderedUnitGuid,
		PST.SpecimenResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser

	FROM dbo.SpecimenTest ST
	
	LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = ST.PatientSpecimenGUID

	LEFT JOIN	dbo.OrderedTest OT ON OT.OrderedTestGUID = ST.OrderedTestGUID

	LEFT JOIN	dbo.RackLot TWRL ON TWRL.RackLotGuid = (SELECT TOP 1 RackLot.RackLotGuid 
								FROM dbo.RackLot
								JOIN dbo.AntiseraOrderedTest ON AntiseraOrderedTest.RackLotGuid = RackLot.RackLotGuid
								WHERE AntiseraOrderedTest.OrderedTestGuid = OT.OrderedTestGuid
								AND RackLot.ControlCellId = 1
								AND RackLot.LotVialNumber IS NULL
								AND ((RackLot.RackGuid IS NULL) OR (RackLot.TestWithId IS NOT NULL))
								AND AntiseraOrderedTest.RecordStatusCode = ST.RecordStatusCode)

	LEFT JOIN	dbo.Reagent TWR ON TWR.ReagentGuid = TWRL.ReagentGuid
	
	LEFT JOIN	dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

	LEFT JOIN	dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

	LEFT JOIN 	dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

	LEFT JOIN 	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

	LEFT JOIN	dbo.BloodTestType BTT ON BTT.BloodTestTypeID = ST.BloodTestTypeID

	LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.OrderableTestID

	LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = ST.TestingMethodCode

	LEFT JOIN	dbo.AntibodyType ANTI ON ANTI.AntibodyTypeID = ST.AntibodyTypeID

	LEFT JOIN	dbo.Rack R ON R.RackGUID = ST.RackGUID

	LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = ST.TestResultID

	LEFT JOIN	dbo.CannedComment CC ON CC.CannedCommentGUID = ST.CannedCommentGUID

	JOIN		dbo.VbecsUser VU ON ST.TestTechID = VU.VbecsUserId

	LEFT JOIN	dbo.VbecsUser IU ON ST.InactivateUser = IU.VbecsUserId
	
	LEFT JOIN dbo.PendingSpecimenTest PST ON PST.SpecimenTestGuid = ST.SpecimenTestGuid

	LEFT JOIN	dbo.VbecsUser LU ON ST.EntryTechId = LU.VbecsUserId

	WHERE	ST.DivisionCode = @divisioncode
	
		AND		ST.TestDate >= @startdate
	
			AND		ST.TestDate <= @enddate
		
				AND		ST.RecordStatusCode IN ('A','E','X')
			
					AND		BTT.OrderableTestID NOT IN (7,9,10,119) -- Don't include TASs (7), TRWs (10) or XMs (9,119)

			UNION

-- TAS Testing from SpecimenTest

	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OT.OrderedTestGUID AS TestGUID,
		'0000000000000' + CONVERT(VARCHAR(40),OT.OrderedTestGUID) AS TestUnitId,
		NULL AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		OT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText + ' (' + REPTEST.OrderableTestText + ')' COLLATE SQL_Latin1_General_CP1_CS_AS AS OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		ST.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE ISNULL(BTT.ReportableTestId,0)
		WHEN 4 THEN
			CASE ISNULL(TWR.LotNumber,'')
			WHEN '' THEN
				BTT.TestedWith
			ELSE
				BTT.TestedWith + ', ' + TWR.LotNumber
			END
		ELSE
			BTT.TestedWith
		END	AS TestedWith,
	--Phase
		ST.BloodTestTypeID AS BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		ST.TestResultID,
		TR.TestResultText,
		NULL AS AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 SpecimenTest.TestDate FROM dbo.SpecimenTest JOIN dbo.BloodTestType ON BloodTestType.BloodTestTypeId = SpecimenTest.BloodTestTypeId WHERE SpecimenTest.OrderedTestGuid = OT.OrderedTestGuid AND ISNULL(SpecimenTest.InactivateDate,'1/1/2000') = ISNULL(ST.InactivateDate,'1/1/2000') AND BloodTestType.ReportableTestId = BTT.ReportableTestId ORDER BY SpecimenTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		ST.TestComments,
		ST.AutoInstrumentName,
		ST.RecordStatusCode AS RecordStatusCode,
		ST.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.InactivateDate) AS InactivateDate,

		CC.CannedCommentText,
		ST.CorrectedResultIndicator,
		NULL AS OffsiteIndicator,
		NULL AS OffsiteLocation,
		--	Instrument Comment
		PST.AutoInstrumentComments,
		NULL AS OrderedUnitGuid,
		PST.SpecimenResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser
		
	FROM dbo.SpecimenTest ST
	
	LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = ST.PatientSpecimenGUID

	LEFT JOIN	dbo.OrderedTest OT ON OT.OrderedTestGUID = ST.OrderedTestGUID

	LEFT JOIN	dbo.RackLot TWRL ON TWRL.RackLotGuid = (SELECT TOP 1 RackLot.RackLotGuid 
								FROM dbo.RackLot
								JOIN dbo.AntiseraOrderedTest ON AntiseraOrderedTest.RackLotGuid = RackLot.RackLotGuid
								WHERE AntiseraOrderedTest.OrderedTestGuid = OT.OrderedTestGuid
								AND RackLot.ControlCellId = 1
								AND RackLot.LotVialNumber IS NULL
								AND ((RackLot.RackGuid IS NULL) OR (RackLot.TestWithId IS NOT NULL))
								AND AntiseraOrderedTest.RecordStatusCode = ST.RecordStatusCode)

	LEFT JOIN	dbo.Reagent TWR ON TWR.ReagentGuid = TWRL.ReagentGuid
	
	LEFT JOIN	dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

	LEFT JOIN	dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

	LEFT JOIN 	dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

	LEFT JOIN 	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

	LEFT JOIN	dbo.BloodTestType BTT ON BTT.BloodTestTypeID = ST.BloodTestTypeID

	LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = OT.OrderableTestID

	LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = ST.TestingMethodCode

	LEFT JOIN	dbo.Rack R ON R.RackGUID = ST.RackGUID

	LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = ST.TestResultID

	LEFT JOIN	dbo.CannedComment CC ON CC.CannedCommentGUID = ST.CannedCommentGUID

	JOIN		dbo.VbecsUser VU ON ST.TestTechID = VU.VbecsUserId

	JOIN		dbo.OrderableTest REPTEST ON REPTEST.OrderableTestID = BTT.ReportableTestID

	LEFT JOIN	dbo.VbecsUser IU ON ST.InactivateUser = IU.VbecsUserId
		
	LEFT JOIN dbo.PendingSpecimenTest PST ON PST.SpecimenTestGuid = ST.SpecimenTestGuid

	LEFT JOIN	dbo.VbecsUser LU ON ST.EntryTechId = LU.VbecsUserId

	WHERE	ST.DivisionCode = @divisioncode

		AND		ST.TestDate >= @startdate
	
			AND		ST.TestDate <= @enddate
		
				AND		ST.RecordStatusCode IN ('A','E','X')
			
					AND		OT.OrderableTestID = 7

			UNION

-- XM Testing from OrderedComponent

	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OC.OrderedComponentGUID AS TestGUID,
		BU.EyeReadableUnitID + CONVERT(VARCHAR(40),OC.OrderedComponentGUID) AS TestUnitId,
		BU.EyeReadableUnitID AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
	
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		ORT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		BUT.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE BU.LabelTypeCode
			WHEN 'I' THEN BU.EyeReadableUnitID+', '+BU.UnitProductCode + BU.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
			ELSE BU.EyeReadableUnitID+', '+BU.UnitProductCode
		END AS TestedWith,
	--Phase
		BUT.BloodTestTypeID AS BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		BUT.TestResultID,
		TR.TestResultText,
		NULL AS AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 BloodUnitTest.TestDate FROM dbo.BloodUnitTest WHERE BloodUnitTest.OrderedComponentGuid = OC.OrderedComponentGuid AND BloodUnitTest.BloodUnitGuid = BUT.BloodUnitGuid AND ISNULL(BloodUnitTest.InactivateDate,'1/1/2000') = ISNULL(BUT.InactivateDate,'1/1/2000') ORDER BY BloodUnitTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		BUT.TestComments,
		BUT.AutoInstrumentName,
		BUT.RecordStatusCode AS RecordStatusCode,
		BUT.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.InactivateDate) AS InactivateDate,

		NULL AS CannedCommentText,
		BUT.CorrectedResultIndicator,
		NULL AS OffsiteIndicator,
		NULL AS OffsiteLocation,
		--	Instrument Comment
		PBUT.AutoInstrumentComments,
		BUT.OrderedUnitGuid,
		PBUT.UnitResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser
	
	FROM
		dbo.BloodUnitTest BUT

		LEFT JOIN dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID

		LEFT JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID

		JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGUID = BUT.OrderedComponentGUID

		LEFT JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID

		LEFT JOIN dbo.PatientOrder PO ON PO.PatientOrderGUID = OC.PatientOrderGUID

		LEFT JOIN dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

		LEFT JOIN dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

		LEFT JOIN dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

		LEFT JOIN dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.OrderableTestID

		LEFT JOIN dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode

		JOIN dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId

		LEFT JOIN dbo.VbecsUser IU ON BUT.InactivateUser = IU.VbecsUserId

		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		LEFT JOIN	dbo.VbecsUser LU ON BUT.EntryTechId = LU.VbecsUserId
	WHERE

		BUT.DivisionCode = @divisioncode

			AND	BUT.RecordStatusCode IN ('A','E','X')
	
				AND BTT.OrderableTestID = 9 -- XM Tests only
		
					AND BUT.TestDate >= @startdate
			
						AND BUT.TestDate <= @enddate

			UNION

-- Repeat XM Testing from OrderedTest
	SELECT DISTINCT

		1 AS TestingWorklistReportType,
		P.PatientGUID,
		PS.PatientSpecimenGUID,
		OT.OrderedTestGUID AS TestGUID,
		BU.EyeReadableUnitID + CONVERT(VARCHAR(40),OT.OrderedTestGUID) AS TestUnitId,
		BU.EyeReadableUnitID AS UnitID,
	--Patient & Specimen Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		PT.PatientLocation,
		PS.Specimenuid AS SpecimenAccessionNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenCollectionDate) AS SpecimenCollectionDate,

	--Test Performed
		ORT.OrderableTestID AS OrderableTestId,
		ORT.OrderableTestText,
		BTT.BloodTestName,
	--Testing Method
		BUT.TestingMethodCode,
		TM.TestingMethodText,
	--Rack
		R.RackName,
	--Tested With
		CASE BU.LabelTypeCode
			WHEN 'I' THEN BU.EyeReadableUnitID+', '+BU.UnitProductCode + BU.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
			ELSE BU.EyeReadableUnitID+', '+BU.UnitProductCode
		END AS TestedWith,
	--Phase
		BUT.BloodTestTypeID AS BloodTestTypeID,
		BTT.Phase,
		BTT.SortColumn,
	--Reaction Result
		BUT.TestResultID,
		TR.TestResultText,
		NULL AS AntibodyTypeName,
	--Testing Tech
		VU.UserName AS TestTechID,
	--Date Tested
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,BUT.TestDate) AS TestDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 BloodUnitTest.TestDate FROM dbo.BloodUnitTest WHERE BloodUnitTest.OrderedTestGuid = OT.OrderedTestGuid AND BloodUnitTest.BloodUnitGuid = BUT.BloodUnitGuid AND ISNULL(BloodUnitTest.InactivateDate,'1/1/2000') = ISNULL(BUT.InactivateDate,'1/1/2000') ORDER BY BloodUnitTest.TestDate DESC)) AS WorklistDate,
	--Additional Info
		BUT.TestComments,
		OT.AutoInstrumentName,
		BUT.RecordStatusCode AS RecordStatusCode,
		BUT.LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) AS LastUpdateDate,

		IU.UserName AS InactivateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS InactivateDate,

		NULL AS CannedCommentText,
		BUT.CorrectedResultIndicator,
		NULL AS OffsiteIndicator,
		NULL AS OffsiteLocation,
		--	Instrument Comment
		PBUT.AutoInstrumentComments,
		BUT.OrderedUnitGuid,
		PBUT.UnitResultSetGuid AS ResultSetGuid,
		LU.UserName AS ReviewUser

	
	FROM
		dbo.BloodUnitTest BUT

		LEFT JOIN dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID

		LEFT JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID

		JOIN dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID

		LEFT JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID

		LEFT JOIN dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

		LEFT JOIN dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

		LEFT JOIN dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

		LEFT JOIN dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

		LEFT JOIN dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.OrderableTestID

		LEFT JOIN dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode

		JOIN dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId

		LEFT JOIN dbo.VbecsUser IU ON BUT.InactivateUser = IU.VbecsUserId

		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID

		LEFT JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		LEFT JOIN	dbo.VbecsUser LU ON BUT.EntryTechId = LU.VbecsUserId
	WHERE

		BUT.DivisionCode = @divisioncode

		AND	BUT.RecordStatusCode IN ('A','E','X')

		AND OT.OrderableTestID = 119 -- Repeat XM Tests only

		AND BUT.TestDate >= @startdate

		AND BUT.TestDate <= @enddate

--BR_48.07
	ORDER BY 

	P.PatientLastName,
	P.PatientFirstName,
	P.PatientMiddleName,
	SpecimenCollectionDate,
	WorklistDate,
	TestUnitId,
	OrderableTestId,
	RecordStatusCode, 
	InactivateDate, 
	BTT.SortColumn, 
	TestDate, 
	R.RackName, 
	TestGUID

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPendingSpecimenTests]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPendingSpecimenTests]
GO


/****** Object:  StoredProcedure [dbo].[spGetPendingSpecimenTests]    Script Date: 3/8/2016 1:43:55 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO






/*******************************************************************************************************************************************************************************
**	Desc:	Returns record from PendingSpecimenTest table (Defect 235354).
**
**	Author:	Russell Stephenson
**
**	Date: 	1/16/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	1/27/2016	Doug Forst	Defect 235354: Changed SpecimenExpirationDate to be converted to local date time
**	1/28/2016	Doug Forst	Defect 235354: Added OrderableTestId param
**	2/04/2016	Doug Forst	Defect 235354: Removed SpecimenUid param and added PatientSpecimenGuid
**	2/16/2016	K.Adu-Poku	Changed RejectComment to RejectionComment
**	2/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	3/02/2016	Doug Forst	Defect 286187: Added error handling
**	3/31/2016	R. Sankala	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetPendingSpecimenTests]
(
	@patientspecimenguid UNIQUEIDENTIFIER,
	@patientguid UNIQUEIDENTIFIER,
	@divisioncode CHAR (5),
	@pendingteststatusid TINYINT,
	@orderabletestid INT = NULL
)

AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT 
		PST.PendingSpecimenTestId,
		PST.SpecimenTestGuid,
		PST.OrderedTestGuid,
		ODT.PatientOrderGuid,
		PS.SpecimenUid,
		PST.PatientSpecimenGuid,
		PS.PatientGuid,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenExpirationDate) AS SpecimenExpirationDate,
		PST.BloodTestTypeId,
		BTT.BloodTestName AS BloodTestTypeName,
		BTT.SortColumn  AS BloodTestTypeSortOrder,		
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PST.TestDate) AS TestDate,
		PST.TestTechId,
		VU.UserName AS TestTechUserName,
		PST.TestResultId,
		TR.TestResultText,
		PST.AutoInstrumentName,
		PST.AutoInstrumentComments,
		PST.DivisionCode,
		PST.PendingTestStatusId,
		PST.RejectionComment,
		PST.SpecimenResultSetGuid,
		OT.OrderableTestId,
		OT.OrderableTestName, 
		BTT.TestedWith AS BloodTestTypeTestedWith,
		PST.LastUpdateUser,
		PST.[RowVersion],
		ODT.CprsOrderNumber

	FROM dbo.PendingSpecimenTest PST
		
		JOIN dbo.PatientSpecimen PS ON PST.PatientSpecimenGuid = PS.PatientSpecimenGuid
		
		JOIN dbo.OrderedTest ODT ON ODT.OrderedTestGuid = PST.OrderedTestGuid

		JOIN dbo.TestResult TR ON TR.TestResultID = PST.TestResultId

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = PST.BloodTestTypeId

		JOIN dbo.OrderableTest OT ON OT.OrderableTestId = BTT.OrderableTestId
		
		LEFT JOIN dbo.VbecsUser VU ON VU.VbecsUserId = PST.TestTechId
	
	WHERE 
		PS.PatientSpecimenGuid = @patientspecimenguid
	    
		AND (@orderabletestid IS NULL OR BTT.OrderableTestId = @orderabletestid)

		AND PST.DivisionCode = @divisioncode

		AND PST.PendingTestStatusId = @pendingteststatusid
		


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetSpecimenTestResultsForOrderedTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetSpecimenTestResultsForOrderedTest]
GO


/****** Object:  StoredProcedure [dbo].[spGetSpecimenTestResultsForOrderedTest]    Script Date: 2/11/2016 8:57:48 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc:	Gets test results for a given ordered test
**
**	Author:	Cameron Taylor
**
**	Date: 	04/09/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	10/18/2004	C. Taylor	Added AboRhChangeIndicator
**	07/08/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name, input/output from comment header, Added NOCOUNT, Specified table owners, spaced out SQL,
					Placed rowversion in brackets
**	01/31/2016	K. Dobranowski	Added JOIN to PendingSpecimenTest to allow invalidation logic to differentiate between automated and manual tests (Defect 251282)
**	02/10/2016	K. Dobranowski	Added JOIN to PendingSpecimenTest to the ELSE part of the stored procedure (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetSpecimenTestResultsForOrderedTest]
(
	@orderedtestguid	UNIQUEIDENTIFIER,
	@reportabletestid	INT = NULL,
	@divisioncode		CHAR(5)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

IF @ReportableTestID IS NULL

	BEGIN

		SELECT DISTINCT

			PS.PatientSpecimenGUID,
			ST.OrderedTestGUID,
			ST.SpecimenTestGUID,
			OT.PatientOrderGUID,
		--Sub Test
			BTT.ReportableTestID,
			ORT.OrderableTestText,
		--Testing Method
			ST.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			ST.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			ST.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			ST.TestResultID,
			TR.TestResultText,
			ST.AntibodyTypeID,
			ANTI.AntibodyTypeName,
		--Testing Tech
			ISNULL(VU.UserName,ST.TestTechID) 				AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ST.TestDate) AS TestDate,
		--Additional Info
			ST.TestComments,
			ST.AutoInstrumentName,
			ST.RecordStatusCode,
			ST.[RowVersion],
			ST.AboRhChangeIndicator,
			PST.SpecimenResultSetGuid
			
		FROM dbo.SpecimenTest ST
		
			JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = ST.OrderedTestGUID
	
			LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = ST.PatientSpecimenGUID
	
			LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = ST.TestingMethodCode
	
			LEFT JOIN	dbo.Rack R ON R.RackGUID = ST.RackGUID
	
			JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = ST.BloodTestTypeID
	
			LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = ST.TestResultID
	
			LEFT JOIN	dbo.AntibodyType ANTI ON ANTI.AntibodyTypeID = ST.AntibodyTypeID
	
			LEFT JOIN	dbo.VbecsUser VU ON ST.TestTechID = VU.VbecsUserId
	
			LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID

			LEFT JOIN	dbo.PendingSpecimenTest PST ON PST.SpecimenTestGuid = ST.SpecimenTestGuid
		
		WHERE	ST.OrderedTestGUID = @orderedtestguid

			AND		ST.RecordStatusCode = 'A'
		
		
		ORDER BY ST.BloodTestTypeID

		SET @ERROR = @@ERROR

	END


ELSE


	BEGIN

		SELECT DISTINCT

			PS.PatientSpecimenGUID,
			ST.OrderedTestGUID,
			ST.SpecimenTestGUID,
			OT.PatientOrderGUID,
		--Sub Test
			BTT.ReportableTestID,
			ORT.OrderableTestText,
		--Testing Method
			ST.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			ST.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			ST.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			ST.TestResultID,
			TR.TestResultText,
			ST.AntibodyTypeID,
			ANTI.AntibodyTypeName,
		--Testing Tech
			ISNULL(VU.UserName,ST.TestTechID) 				AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,ST.TestDate) 	AS TestDate,
		--Additional Info
			ST.TestComments,
			ST.AutoInstrumentName,
			ST.RecordStatusCode,
			ST.[RowVersion],
			ST.AboRhChangeIndicator,
			PST.SpecimenResultSetGuid
			
		FROM dbo.SpecimenTest ST
		
			JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = ST.OrderedTestGUID
	
			LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = ST.PatientSpecimenGUID
	
			LEFT JOIN		dbo.TestingMethod TM ON TM.TestingMethodCode = ST.TestingMethodCode
	
			LEFT JOIN	dbo.Rack R ON R.RackGUID = ST.RackGUID
	
			JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = ST.BloodTestTypeID
	
			LEFT JOIN	dbo.TestResult TR ON TR.TestResultID = ST.TestResultID
	
			LEFT JOIN	dbo.AntibodyType ANTI ON ANTI.AntibodyTypeID = ST.AntibodyTypeID
	
			LEFT JOIN		dbo.VbecsUser VU ON ST.TestTechID = VU.VbecsUserId
	
			LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
			
			LEFT JOIN	dbo.PendingSpecimenTest PST ON PST.SpecimenTestGuid = ST.SpecimenTestGuid

		WHERE	ST.OrderedTestGUID = @orderedtestguid

			AND		BTT.ReportableTestID = @reportabletestid

				AND		ST.RecordStatusCode = 'A'
		
		ORDER BY ST.BloodTestTypeID

		SET @ERROR = @@ERROR

	END
		
SET NOCOUNT OFF

RETURN @ERROR


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName]
GO

/****** Object:  StoredProcedure [dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName]    Script Date: 4/4/2016 1:05:39 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO







/*******************************************************************************************************************************************************************************
**	Desc:	Returns record from OrderedTest table (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	1/21/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name				Description
**	1/26/2016	Russell Stephenson	Defect 235352:  Added condition for TaskStatusCode = 'E'
**	1/27/2016	Russell Stephenson	Defect 235352:  Added addtional parameter for BloodTestName for patient antigen typing and added collation for case sensitivity.
**	1/28/2016	Russell Stephenson	Defect 235352:  Added test name for orderable test and added OrderStatusCode to the projection for the returned datatable.
**	1/30/2016	K. Dobranowski		Defect 251282:	Modified length of @specimenuid to 15 to match the DB design
**	2/01/2016	K. Dobranowski		Defect 251282:	Modified WHERE clause to allow acceptance of results for expired orders
**	2/02/2016	Russell Stephenson	Defect 235352:	Added @divisioncode and taskstatuscode of A.
**	2/17/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	3/23/2016	Russell Stephenson	Defect 286186:	Added error handling and return.
**	4/01/2016	Russell Stephenson	Defect 300432:	Added TaskStatusCode to select presentation.
**	4/04/2016	R. Sankala		** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName]
(
	@specimenuid VARCHAR(15),
	@testpanelname VARCHAR(35),
	@bloodtestname  VARCHAR(35) = NULL,
	@divisioncode CHAR(5)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT  
		OT.OrderedTestGuid,
		OT.PatientSpecimenGuid,
		OT.OrderableTestId,
		OT.[RowVersion],
		ORT.OrderableTestName,
		OT.OrderStatusCode,
		OT.TaskStatusCode
	FROM 
		dbo.OrderedTest OT 
		
		INNER JOIN dbo.PatientSpecimen PS	ON OT.PatientSpecimenGuid = PS.PatientSpecimenGuid
		
		INNER JOIN dbo.OrderableTest ORT ON ORT.OrderableTestId = OT.OrderableTestId
	WHERE  
		PS.SpecimenUid = @specimenuid 
		AND (OT.OrderStatusCode  = 'A' OR (OT.OrderStatusCode = 'X' AND OT.TaskStatusCode = 'E'))
		AND OT.TaskStatusCode IN ('N','R','E','A') 
		AND OT.DivisionCode = @divisioncode
		AND OT.OrderableTestId IN 
		(
		SELECT DISTINCT BTT.OrderableTestId 
		FROM dbo.BloodTestType BTT 
		INNER JOIN dbo.BloodTestTypeMapping BTTM 
		ON  BTTM.BloodtestTypeId = BTT.BloodTestTypeId
		WHERE BTTM.BloodPanelName = @testpanelname COLLATE SQL_Latin1_General_CP1_CS_AS
		AND (@bloodtestname IS NULL OR BTTM.BloodTestName = @bloodtestname COLLATE SQL_Latin1_General_CP1_CS_AS)
		)


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)






GO





if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetPendingSpecimenTest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetPendingSpecimenTest]
GO

/****** Object:  StoredProcedure [dbo].[spHL7GetPendingSpecimenTest]    Script Date: 3/24/2016 11:43:27 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc:	Returns record from PendingSpecimenTest table (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	1/16/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name				Description
**	1/25/2016	Russell Stephenson	Added @BloodTestTypeId to verify that this is the exac same pending test (Defect 235352).
**	1/27/2016	Russell Stephenson	Added Change tinyint to int for @bloodtesttypeid (Defect 235352).
**	2/12/2016	K.Adu-Poku		Changed RejectComment to RejectionComment
**	2/17/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	5/20/2016	Russell Stephenson	Defect 286186:	Added error handling and return and corrected TestDate.
**	5/23/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spHL7GetPendingSpecimenTest]
(
	@specimenuid VARCHAR(15),
	@divisioncode CHAR(5),
	@pendingteststatusid TINYINT,
	@bloodtesttypeid	INT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT 
		PST.PendingSpecimenTestId,
		PST.SpecimenTestGuid,
		PST.OrderedTestGuid,
		PST.PatientSpecimenGuid,
		PST.BloodTestTypeId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PST.TestDate) AS TestDate,
		PST.TestTechId,
		PST.TestResultId,
		PST.AutoInstrumentName,
		PST.AutoInstrumentComments,
		PST.DivisionCode,
		PST.PendingTestStatusId,
		PST.RejectionComment,
		PST.SpecimenResultSetGuid,
		PST.LastUpdateDate,
		PST.LastUpdateUser,
		PST.[RowVersion],
		PST.LastUpdateFunctionId
	FROM 
		dbo.PendingSpecimenTest PST
		JOIN dbo.PatientSpecimen PS ON PST.PatientSpecimenGuid = PS.PatientSpecimenGuid
	WHERE 
		PS.SpecimenUid = @specimenuid
	    
		AND PST.DivisionCode = @divisioncode

		AND PST.PendingTestStatusId = @pendingteststatusid
				
		AND PST.BloodTestTypeId = @bloodtesttypeid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[batchspRunExpireTestOrders]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[batchspRunExpireTestOrders]
GO

/****** Object:  StoredProcedure [dbo].[batchspRunExpireTestOrders]    Script Date: 2/1/2016 11:25:33 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc:  This sp is used to expire TAS orders, it is part of Expire Orders background job
**
**	Author: Krzysztof Dobranowski
**
**	Date: 	11/10/2009
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	11/10/2009	K.Dobranowski	Initial creation (CR 2368)
**	08/15/2011	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	03/12/2013	Lohse			Updated to use new spInsertVbecsLock and spDeleteVbecsLock sprocs, set LockFunctionId = 995
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/20/2014	Lohse		CR 3409 - adding LockInactivityTimeoOutMin parameter needed by spInsertVbecsLock,, updated logic to continue after error/rollback
**	03/28/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/01/2016	K. Dobranowski	Added status of 'A' (Pending Review from Auto Instrument) to the check so that orders that have pending results are not marked as expired (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[batchspRunExpireTestOrders]

AS

SET NOCOUNT ON

DECLARE 

	@orderedTestGuid	 	UNIQUEIDENTIFIER,
	@divisionCode 			CHAR(5),
	@message 			VARCHAR(80),
	@lastError			INT,
	@expiredOrdersCount		INT,
	@currentOrderedTestId 		INT,
	@sessionguid			UNIQUEIDENTIFIER,
	@lockfunctionid			INT,
	@fakeformid				INT,
	@lockinactivitytimeoutmin INT

DECLARE @ExpiredOrders TABLE 
(	

	[Id] 			INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	OrderedTestGuid 	UNIQUEIDENTIFIER,
	DivisionCode 		CHAR(5) 

);

	SET @lockfunctionid = 995
	SET @fakeformid = -995
	SET @sessionguid = NEWID()
		
	INSERT INTO @ExpiredOrders( OrderedTestGuid, DivisionCode )

		SELECT 

			OT.OrderedTestGuid,
			OT.DivisionCode

		FROM 

			dbo.OrderedTest OT

			JOIN dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

			LEFT JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID

		WHERE 

			OT.OrderStatusCode = 'A' AND
			((OT.TaskStatusCode != 'E' AND OT.TaskStatusCode != 'A') OR OT.TaskStatusCode IS NULL) AND
			OT.OrderableTestId = 7 AND

			(

			/*If there is no specimen the expiration date is 10 days from AcceptanceDate*/
			(PS.SpecimenExpirationDate IS NULL AND
			GETUTCDATE() > DATEADD(DAY, 10, OT.OrderAcceptanceDate))

			OR

			/*If specimen exists the expiration date of the order is the same as expiration date of associated specimen*/
			(PS.SpecimenExpirationDate IS NOT NULL AND
			PS.SpecimenExpirationDate < GETUTCDATE())

			)	
	
	SELECT @expiredOrdersCount = @@ROWCOUNT, @lastError = @@ERROR 

	IF @lastError <> 0 

		BEGIN 
	
			RETURN @lastError 
	
		END

	SET @currentOrderedTestId = 1
	
/*=========================================================> B E G I N  L O O P  <=====================================================*/
	WHILE @currentOrderedTestId <= @expiredOrdersCount

	BEGIN

		
	
			
				SELECT	@orderedTestGuid = tmpTable.OrderedTestGuid,
						@divisionCode = tmpTable.DivisionCode,
						@lockinactivitytimeoutmin = LockInactivityTimeoutMin
		
				FROM	@ExpiredOrders tmpTable
				JOIN	dbo.VamcDivision ON VamcDivision.DivisionCode = tmpTable.DivisionCode
		
				WHERE	[Id] = @currentOrderedTestId

		
	BEGIN TRANSACTION Comp



				EXECUTE @lastError =  dbo.spInsertVbecsLock @orderedTestGuid, null, @fakeformid, @fakeformid, @lockfunctionid, 'VBECS', @lockfunctionid, @lockinactivitytimeoutmin, @divisionCode, @sessionguid,0

				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
			
				IF @lastError <> 0 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
	/*	=============================  THE LOCK HAS BEEN PLACED NOW DO THE UPDATE ==========================================================*/
	
				
	
				UPDATE 
			
					dbo.OrderedTest
			
				SET 
					OrderStatusCode = 'X',
					OrderedTestComments = 'Canceled by background job',
					TaskStatusCode = 'E',
					LastUpdateDate = GETUTCDATE(),
					LastUpdateUser = 'VBECS'	
			
				FROM 
			
					dbo.OrderedTest
			
					JOIN
						@ExpiredOrders ExpOrders ON ExpOrders.OrderedTestGuid = dbo.OrderedTest.OrderedTestGuid
				
					JOIN
				
						dbo.VbecsLock ON dbo.VbecsLock.LockedRecordGuid = dbo.OrderedTest.OrderedTestGuid 
				
						          AND SessionGuid = @sessionguid
			
				WHERE ExpOrders.OrderedTestGuid = @orderedTestGuid AND SessionGuid = @sessionguid
			
				SET @lastError = @@ROWCOUNT + @@ERROR
			
				IF @lastError <> 1 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
		
	
	/*	========================================= UPDATE COMPLETED =========================================================================*/
	
	/*	========================================= RELEASE THE LOCK  =========================================================================*/
	
				EXECUTE @lastError = dbo.spDeleteVbecsLock @orderedTestGuid, null, @fakeformid, @lockfunctionid, 'VBECS', NULL, @divisioncode, @sessionguid, @fakeformid
			
				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
			
				IF @lastError <> 0 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
				
				ELSE
		
			/* All of our actions have NOT resulted in an error - so commit the transaction:  */
		
					BEGIN
			
						COMMIT TRANSACTION Comp
			
					END
	/*	========================================= LOCK RELEASE  COMPLETED ==================================================================*/
ContinueWithNextRecord:
				/* Increment @currentOrderedTestId  by one until <= @expiredOrdersCount : */
				SET @currentOrderedTestId = @currentOrderedTestId + 1;
	
	END


/*=========================================================> END  L O O P  <=====================================================*/

	

SET NOCOUNT OFF

RETURN(@lastError)

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetXMBySpecimenUIDAndUnitID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetXMBySpecimenUIDAndUnitID]
GO

/****** Object:  StoredProcedure [dbo].[spHL7GetXMBySpecimenUIDAndUnitID]    Script Date: 3/24/2016 11:50:46 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************************************************************
**	Desc:	Checks for existence of XM or Repeat XM for a given SpecimenUID and Blood Unit ID (Defect 251282)
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	1/30/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name				Description
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/23/2016	K. Dobranowski	Added error handling. (Defect 286179)
**	03/31/2016	R. Sankala	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spHL7GetXMBySpecimenUIDAndUnitID]
(
	@specimenuid		VARCHAR(15),
	@eyeReadableUnitId	VARCHAR(13),
	@divisioncode		VARCHAR(5)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT  
		OU.OrderedUnitGuid,
		OU.OrderedTestGuid,
		ISNULL(OT.PatientSpecimenGuid, OC.PatientSpecimenGuid) AS PatientSpecimenGuid,
		OT.OrderableTestId,
		OT.[RowVersion],
		ORT.OrderableTestName,
		OT.OrderStatusCode,
		OU.OrderedComponentGuid,
		OU.BloodUnitGuid

	FROM 
		OrderedUnit OU

		LEFT JOIN OrderedTest OT ON OT.OrderedTestGuid = OU.OrderedTestGuid

		LEFT JOIN OrderedComponent OC ON OC.OrderedComponentGuid = OU.OrderedComponentGuid
		
		INNER JOIN PatientSpecimen PS ON PS.PatientSpecimenGuid = ISNULL(OT.PatientSpecimenGuid, OC.PatientSpecimenGuid)
		
		LEFT JOIN OrderableTest ORT ON ORT.OrderableTestId = OT.OrderableTestId

		INNER JOIN BloodUnit BU ON BU.BloodUnitGuid = OU.BloodUnitGuid

	WHERE  
		PS.SpecimenUid = @specimenuid 
		AND ISNULL(OT.OrderStatusCode,'A')  = 'A' 
		AND (ISNULL(OT.TaskStatusCode,'N') = 'N' OR ISNULL(OT.TaskStatusCode,'R') = 'R' OR ISNULL(OT.TaskStatusCode,'E') = 'E') 
		AND (ISNULL(OC.OrderStatusCode,'A') = 'A' OR ISNULL(OC.TaskStatusCode,'E') = 'E')
		AND OU.CrossmatchDate IS NULL
		AND OU.ReleaseDate IS NULL
		AND OU.CrossmatchRequiredIndicator = 1
		AND BU.EyeReadableUnitId = @eyeReadableUnitId
		AND OU.DivisionCode = @divisioncode
		AND OU.RecordStatusCode = 'A'

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spIsPendingBloodUnitTestLocked]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spIsPendingBloodUnitTestLocked]
GO

/****** Object:  StoredProcedure [dbo].[spIsPendingBloodUnitTestLocked]    Script Date: 2/18/2016 10:05:26 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/********************************************************************************************************************************
**
**	Desc:	Checks if blood unit is locked by another user. Used by Automated Instrument parsing.
**
**	Author: Greg Lohse
**
**	Date: 	1/30/2016
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	----------	-----------		---------------------------
**	02/18/2016	Lohse			Initial writing. Defect 251417. Adding locking to Automated Instrument parsing
**	02/18/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spIsPendingBloodUnitTestLocked]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@labelunitid		VARCHAR(13),
	@orderedunitguid	UNIQUEIDENTIFIER,
	@divisioncode		CHAR(5)
)
AS

SET NOCOUNT ON

DECLARE @returnvalue	BIT
SET @returnvalue = 0
	
IF EXISTS (
			SELECT 1
			FROM
				dbo.BloodUnit bu
				JOIN	dbo.BloodUnitStatus bus
						ON bu.BloodUnitGuid = bus.BloodUnitGUID 
				JOIN	dbo.VbecsLock vl
						ON bus.BloodUnitStatusGuid = vl.LockedRecordGuid 
			WHERE
				(
					(@bloodunitguid IS NULL AND bu.LabelUnitId = @labelunitid)
				OR
					(@bloodunitguid IS NOT NULL AND bu.BloodUnitGuid = @bloodunitguid)
				)
				AND bu.DivisionCode = @divisioncode
				AND bu.RecordStatusCode = 'A'
			)

	SET @returnvalue = 1


/*********************CHECK ORDERED UNIT***********************/

IF @returnvalue = 0
	BEGIN
		IF @orderedunitguid IS NOT NULL
			BEGIN
				IF EXISTS (
						SELECT 1
						FROM
							dbo.VbecsLock
						WHERE
							LockedRecordGuid = @orderedunitguid 
						)
				SET @returnvalue = 1
			END
	END
	

SET NOCOUNT OFF

RETURN(@returnvalue)



GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spIsPendingSpecimenTestLocked]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spIsPendingSpecimenTestLocked]
GO

/****** Object:  StoredProcedure [dbo].[spIsPendingSpecimenTestLocked]    Script Date: 2/18/2016 10:10:08 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/********************************************************************************************************************************
**
**	Desc:	Checks if the specimen or its test components are locked by another user. Used by Automated Instrument parsing.
**
**	Author: Greg Lohse
**
**	Date: 	1/30/2016
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	----------	-----------		---------------------------
**	02/18/2016	Lohse			Initial writing. Defect 251417. Adding locking to Automated Instrument parsing
**	02/18/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spIsPendingSpecimenTestLocked]
(
	@patientspecimenguid	UNIQUEIDENTIFIER,
	@orderedtestguidarray	VARCHAR(4000),
	@divisioncode			CHAR(5)
)
AS

SET NOCOUNT ON

DECLARE @returnvalue	BIT

SET @returnvalue = 0		--default

/**************CHECK PATIENTSPECIMEN FIRST SINCE ITS THE LEAST AMOUNT OF WORK****************/
IF EXISTS (
			SELECT 1
			FROM
				dbo.VbecsLock vl
			WHERE
				vl.LockedRecordGuid = @patientspecimenguid
			)
		SET @returnvalue = 1



--No lock, so try the next check-- check performance of JOIN vs WHERE IN for TEMP table
IF @returnvalue = 0 AND @orderedtestguidarray IS NOT NULL
	BEGIN
		--Extract the list of OrderedTestGuids into a temporary table
		DECLARE @TempOT TABLE(PendingOrderedTestGuid	UNIQUEIDENTIFIER)
		INSERT INTO @TempOT
		SELECT Item FROM dbo.fnSplit(@orderedtestguidarray, ',')

		IF EXISTS (
				SELECT 1
				FROM
					dbo.VbecsLock vl
					JOIN	@TempOT tmp 
							ON tmp.PendingOrderedTestGuid = vl.LockedRecordGuid
					)
			SET @returnvalue = 1
	END


SET NOCOUNT OFF

RETURN(@returnvalue)



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetLimitedBloodUnit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetLimitedBloodUnit]
GO


/****** Object:  StoredProcedure [dbo].[spGetLimitedBloodUnit]    Script Date: 2/10/2016 4:40:30 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/********************************************************************************************************************************
**	Desc: 	Selects blood units with a 'Limited' status for an invoice
**
**	Author: 	Mike Smith	
**	Date: 	9/24/2002
**
*********************************************************************************************************************************
**	Modified:
** 	Date		Name			Description
**	---------	-----------		-----------------------------------------------------------
**	06/17/2003	M.Jablonski		Commented Assigned Name and SSN and Specimen Exp. Date to compile
**	8/12/03		C.Taylor		Added UnitLotContainerNumber & IncomingShipmentGUID after it was added to vw_BloodUnitsWithCurrentStatus
**	11/04/2003	Greg Lohse		Added BloodProductGUID - needed by Worklistbuilder for UC2 to build a BloodUnit by DataRow
**	11/05/2003	Greg Lohse		Added the ProductTypeCode check as designated by BR_??
**	11/07/2003	Lohse			Adding LabelTypeCode for WorkListBuilder
**	11/12/03	C. Taylor		Added AboRh for WorkListBuilder
**	12/16/03	Lohse			Added RTRIM to BloodTypeCode.  It's a 2char field, we want no spaces for A, B, O. -- it screws us UC5 filter
**	01/13/2004	C. Taylor		Added DisplayVistaPatientId
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	01/20/2005	D. Askew		Changed to DiscardDetailCode DiscardCannedCommentGuid
**	02/08/2005	Lohse			Adding Rhnegatvie parameter to filter negative units , BiohazardousWarningIndicator
**	04/08/2005	Lohse			Adding @allowallunitstatus parameter - to allow selection of already confirmed units for BR_2.42
**	04/12/2005	Lohse			Adding logic for BR2.04 - don't allow units already on another worklist (inprogress)
**	05/31/2005	Lohse			Adding logic for BR11_04 - dont' allow units on a outgoing shipment (unconfirmed)
**	06/17/2005	NPaterson		Modified to use new view for increased performance
**	07/11/2005	Lohse			Adding new product types (52-54) for BR_2.07 change
**	07/15/2005	N.Paterson		** Reviewed for compliance with database standards and recommendations **
**								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**								NOTE: The following are hardcoded:  BloodTestTypeId ,ProductTypeCode,UnitStatusCode, RhFactorCode consider using subquery instead
**	07/11/2005	Lohse			Adding new product types (52-54) for BR_2.07 change
**	08/19/2005	N.Paterson		Implemented differences between Review_Start and DEV before porting changes to DEV
**	08/30/2005	S.Antropov		Replaced list of product codes with reference to component class ID in WHERE clause (for RBC and whole blood)
**	03/09/2006	Lohse			Swapped PendingTransfer logic to use PendingTransferIndicator now being returned in vw_BloodShipPatientAllCurrent
								Reformatting IN CLAUSES to improve performance
**	05/25/2006	Lohse			Adding UnitDivisionId in order to display FullproductCode to user
**	05/06/2015	Lohse			CR3558 - Replacing WHERE RBC/WB check to determine LIMITED units with new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	02/10/2016	Lohse			Defect 251426: Added check for Pooled ABO, removed redundant call for BloodUnitTest records. 
**								Returns single row now and only fields needed - used for re-confirmation only.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetLimitedBloodUnit]
(
	@bloodunitguid	  	UNIQUEIDENTIFIER,
	@divisioncode		CHAR(5)
)

AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BloodUnitGUID,
		RhFactorCode,
		BloodTypeCode,
		PendingTransferIndicator,
		UnitStatusCode

	FROM

		dbo.vw_BloodShipPatientAllCurrent

	WHERE
		BloodUnitGuid = @bloodunitguid
	AND	UnitStatusCode IN ('L', 'A', 'S', 'C')
	AND	AboRhConfirmationRequired = 1 --CR3558
	AND	DivisionCode = @divisioncode
	AND	PendingTransferIndicator = 0
	AND BloodTypeCode <> 'Mx'		--Defect 251426
	

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)




GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetLimitedBloodUnitsByDivision]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetLimitedBloodUnitsByDivision]
GO

/****** Object:  StoredProcedure [dbo].[spGetLimitedBloodUnitsByDivision]    Script Date: 2/10/2016 4:44:48 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc: 	Selects blood units with a 'Limited' status for a division.
**
**	Author: 	Mike Smith	
**	Date: 	2/7/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name			Description
**	---------	-----------		-----------------------	
**	06/16/03	Lohse			Removed fields due to vw_BloodUnitsWithCurrentStatus having changed (changes denoted with --1 ) 
**	08/12/03	C Taylor		Added UnitContainerLotNumber after it was been added to vw_BloodUnitsWithCurrentStatus
**	10/07/03	Lohse			Looks like UC2 is the only area in the app using this, so I tacked on another parameter (just in case) to limit the bloodunits based on producttype
**	11/04/03	Lohse			Adding BloodProductGUID -- needed for building BloodUnit object using DataRow constructor
**	11/07/03	Lohse			Adding LabelTypeCode for WorklistBuilder
**	12/16/03	Lohse			Added RTRIM to BloodTypeCode.  It's a 2char field, we want no spaces for A, B, O. -- it screws up UC5 filter
**	01/13/2004	C. Taylor		Added DisplayVistaPatientId
**	02/10/2004	Greg Lohse		Adding UnitDivisionId for ISBT alloQUAT search. Adding FullProductCode
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor		Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor		Added PresumedTransfusedIndicator
**	01/20/2005	D. Askew		Changed to DiscardDetailCode DiscardCannedCommentGuid
**	02/08/2005	Lohse			Adding parameter to restrict data by RhFactor
**	04/11/2005	Lohse			Changing ProductType to BIT
**	04/12/2005	Lohse			Adding logic for BR_2.04 - don't allow units that are already on another worklist (inprogress)
**	05/31/2005	Lohse			Adding logic for BR_11.04 - don't allow units that have been added to an outgoing shipment (confirmed or not)
**	06/17/2005	Npaterson		Changed to use new view to increase performance
**	07/11/2005	Lohse			Adding new ProductTypes for BR_2.07 change
**	07/15/2005	N.Paterson		** Reviewed for compliance with database standards and recommendations **
								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
								NOTE: BloodTestTypeId,ProductTypeCode,UnitStatusCode,RhFactorCode are hard coded in the WHERE clause 
								consider using subqueries instead so if values change in table proc code does not have to be changed.
**	07/21/2005	Lohse			Adding ORDER BY EyeReadableUnitId, FullProductCode
**	08/30/2005	S.Antropov		Replaced list of product codes with reference to component class ID in WHERE clause (for RBC and whole blood)
**	03/09/2006	Lohse			Swapped PendingTransfer logic to use PendingTransferIndicator now being returned in vw_BloodShipPatientAllCurrent
								redoing the IN clauses to increase performance
**	05/06/2015	Lohse			CR3558 - Replacing WHERE RBC/WB check to determine LIMITED units with new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	02/10/2016	Lohse			Defect 251426 - do not allow Pooled ABOs. Removed redundant query. Removed @allowallproducttypes - not needed due to PT1.06
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetLimitedBloodUnitsByDivision]
(
	@divisioncode			VARCHAR(5),
	@allownegativerh		BIT,
	@shipmentguid			UNIQUEIDENTIFIER = NULL
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BloodUnitGUID,
		EyeReadableUnitID,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 					AS  UnitExpirationDate,

		DonationTypeID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate)						 AS  UnitInDate,

		DivisionCode,
		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitID,
		ProductTypeCode,
		ProductName,
		ProductShortName,
		BiohazardousWarningIndicator,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		IncomingShipmentGUID,
		RTRIM(BloodTypeCode) + ' ' + RhFactorText 									AS AboRh,
		UnitContainerLotNumber,
		BloodProductGUID,
		LabelTypeCode,
		UnitDivisionId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) 						AS ShipmentDate,

		PresumedTransfusedIndicator,

		CASE LabelTypeCode

			WHEN 'I' THEN 

				UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

			ELSE 

				UnitProductCode

		END 														AS FullProductCode 

	FROM	

		dbo.vw_BloodShipPatientAllCurrent

	WHERE 

		UnitStatusCode = 'L'
	
	AND	DivisionCode = @DivisionCode

	AND	((@allownegativerh = 0  AND RhFactorCode != 'N') OR (@allownegativerh = 1))

	AND	AboRhConfirmationRequired = 1	--CR3558
	
	AND (
			@shipmentguid IS NULL 
		OR (@shipmentguid IS NOT NULL AND @shipmentguid = IncomingShipmentGuid)
		)
	
	AND	PendingTransferIndicator = 0
	
	AND BiohazardousWarningIndicator = 0	--CR945
	
	AND QuarantineIndicator = 0				--CR945
	
	AND BloodTypeCode <> 'Mx'				--Defect 251426

	ORDER BY

		EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)



GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays]
GO


/****** Object:  StoredProcedure [dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays]    Script Date: 2/4/2016 2:28:34 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/********************************************************************************************************************************
**
**	Desc: 	Selects shipments that were received within the last 5 days.
**
**	Author: Carl Jensen
**
**	Date: 	11/14/2002
**
*********************************************************************************************************************************
**	Modified:
** 	Date		Name			Description
**	---------	----------		-----------------------------
**	9/17/03		C Taylor		Changed sort order to Shipment Date DESC
**	04/20/2004	M.Jablonski		Call fnTimeZoneConversionDateTime function on all dates
** 	10/11/2003	C.VanStedum		Added changes for the addition of the bloodunitshipmenttable
**	01/20/2005	Lohse			BloodUnitShipment was being joined on Incoming and OutgoingShipmentGuid.  
**								Removed Outgoing ( BR27.09)
**	07/07/2005	NPaterson		** Reviewed for compliance with database standards and recommendations **
**								Removed name, input/output from comment header, Added NOCOUNT, Specified table owners, spaced out SQL,
								Placed brackets around input parameter
**	07/07/2005	D. Askew		Added condition to ensure invoices have at least one unit that is not in final status
**	08/21/2005	S. Antropov		** Reviewed for compliance with database standards and recommendations **
**								Performed secondary review during the code promotion - merged changes
**	11/20/2005	Lohse			Adding RecordStatusCode check against Shipment table to avoid Modification created "fake" invoices
**	01/23/2006	M Smith			** Reviewed for compliance with database standards and recommendations **
**	01/04/2010	M. Smith		Changed to check UnitStatusCode from the BloodUnitStatusCodeCurrent table. (CR 1174)
**	01/27/2010	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	02/03/2016	Lohse			Changing WHERE from NOT IN D,M,T,X to IN L,A,S,C to exluse Issue. Formatted. Defect 251426
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays]
(
	@divisioncode	CHAR (5)
)

AS

SET NOCOUNT ON

	DECLARE @validdate	DATETIME
    DECLARE @error		INT

	SET @validdate = DATEADD(d, -5, GETUTCDATE())

	SELECT DISTINCT
		S.ShipmentGuid,
		InvoiceNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		LS.FacilityName,
		S.LocalSupplierGuid,
		ShipmentDirection
	FROM
		dbo.Shipment S 
			JOIN dbo.LocalSupplier LS 
				ON S.LocalSupplierGUID = LS.LocalSupplierGUID	
			JOIN dbo.V_BloodUnit BU 
				ON BU.IncomingShipmentGuid = S.ShipmentGuid
	WHERE
		S.ShipmentDate > @validdate
	AND UnitStatusCode IN ('L','A','S','C')
	AND	BU.DivisionCode = @divisioncode
	AND S.DivisionCode = @divisioncode
	AND S.RecordStatusCode = 'A'
	
	ORDER BY
		ShipmentDate DESC

SET @error = @@ERROR

SET NOCOUNT OFF 

RETURN (@error)
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetPendingBloodUnitXMTests]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetPendingBloodUnitXMTests]
GO

/****** Object:  StoredProcedure [dbo].[spGetPendingBloodUnitXMTests]    Script Date: 3/8/2016 1:42:23 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/********************************************************************************************************************************
**	Desc:	Returns XM records from PendingBloodUnitTest table (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	02/04/2016
*********************************************************************************************************************************
**	Modified
**	Date		Name			Description
**	----------	--------		-------------------------
**	02/08/2016	Doug Forst		Defect 235354 - Separated PatientOrderGuid and RowVersion for OrderedTest and OrderedComponent
**	02/09/2016	Doug Forst		Defect 235354 - Added OrderedUnitRowVersion and OrderedUnitSelectedDate to the select list
**	02/10/2016	Doug Forst		Defect 235354 - Added OrderedTestCprsOrderNumber and OrderedComponentCprsOrderNumber to the select list
**	02/12/2016	K.Adu-Poku		Changed RejectComment to RejectionComment
**	02/17/2016	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	02/29/2016	Doug Forst		Defect 284963 - Added support to allow OrderedUnitGuid to be null in PendingBloodUnitTest table
**	03/02/2016	Doug Forst		Defect 286187 - Added error checking and changed DateTimes to return the division's local DateTime
**	03/31/2016	R. Sankala		** Reviewed for compliance with database standards and recommendations **
*****************************************************************************************************************************************/


CREATE PROCEDURE [dbo].[spGetPendingBloodUnitXMTests]
(
	@divisioncode	CHAR(5),
	@pendingteststatusid	TINYINT,
	@patientspecimenguid UNIQUEIDENTIFIER
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON		

	-- Select Blood Unit Data
	SELECT DISTINCT
		PS.PatientSpecimenGuid,
		PS.SpecimenUid,
		ORT.PatientOrderGuid AS OrderedTestPatientOrderGuid,
		OC.PatientOrderGuid AS OrderedComponentPatientOrderGuid,
		PBUT.OrderedUnitGuid,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, OU.SelectedDate) AS OrderedUnitSelectedDate,
		OU.OrderedTestGuid,
		OU.OrderedComponentGuid,		
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenExpirationDate) AS SpecimenExpirationDate,
		PS.PatientGuid,
		ORT.CprsOrderNumber as OrderedTestCprsOrderNumber,
		OC.CprsOrderNumber AS OrderedComponentCprsOrderNumber,
		OU.[RowVersion] AS OrderedUnitRowVersion,
		ORT.[RowVersion] AS OrderedTestRowVersion,
		OC.[RowVersion] AS OrderedComponentRowVersion
	  FROM 
	  
		dbo.PendingBloodUnitTest PBUT

		LEFT JOIN dbo.OrderedUnit OU ON OU.OrderedUnitGuid = PBUT.OrderedUnitGuid
									AND (OU.OrderedTestGuid = PBUT.OrderedTestGuid OR OU.OrderedComponentGuid = PBUT.OrderedComponentGuid)
									AND OU.RecordStatusCode = 'A'

		LEFT JOIN dbo.OrderedTest ORT ON ORT.OrderedTestGuid = PBUT.OrderedTestGuid 

		LEFT JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGuid = PBUT.OrderedComponentGuid 

		JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = ORT.PatientSpecimenGuid
									OR PS.PatientSpecimenGuid = OC.PatientSpecimenGuid

	  WHERE 
	  
		PBUT.DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

		AND PS.PatientSpecimenGuid = @patientspecimenguid

		
	SELECT
		PBUT.PendingBloodUnitTestId, 
		PBUT.BloodUnitTestGuid, 
		PBUT.BloodUnitGuid,
		PBUT.BloodTestTypeId,
		BTT.BloodTestName  AS BloodTestTypeName,
		BTT.SortColumn AS BloodTestTypeSortOrder,
		PBUT.BloodUnitId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PBUT.TestDate) AS TestDate,
		PBUT.TestTechId,
		VU.UserName AS TestTechUserName,
		PBUT.TestResultId,
		TR.TestResultText, 
		PBUT.AutoInstrumentComments, 
		PBUT.OrderedUnitGuid,
		PBUT.OrderedTestGuid,
		PBUT.OrderedComponentGuid,
		PBUT.AutoInstrumentName,
		PBUT.DivisionCode,
		PBUT.PendingTestStatusId,
		PBUT.RejectionComment,
		PBUT.UnitResultSetGuid,
		OT.OrderableTestId,
		OT.OrderableTestName, 
		BTT.TestedWith AS BloodTestTypeTestedWith,
		PBUT.LastUpdateUser,
		PBUT.[RowVersion]
	  FROM 
	  
		dbo.PendingBloodUnitTest PBUT

		LEFT JOIN dbo.OrderedUnit OU ON OU.OrderedUnitGuid = PBUT.OrderedUnitGuid
				AND (OU.OrderedTestGuid = PBUT.OrderedTestGuid OR OU.OrderedComponentGuid = PBUT.OrderedComponentGuid)
				AND OU.RecordStatusCode = 'A'

		LEFT JOIN dbo.OrderedTest ORT ON ORT.OrderedTestGuid = PBUT.OrderedTestGuid 

		LEFT JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGuid = PBUT.OrderedComponentGuid 

		JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = ORT.PatientSpecimenGuid
									OR PS.PatientSpecimenGuid = OC.PatientSpecimenGuid

		JOIN dbo.TestResult TR ON TR.TestResultID = PBUT.TestResultID

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = PBUT.BloodTestTypeId

		LEFT JOIN dbo.OrderableTest OT ON OT.OrderableTestId = BTT.OrderableTestId
		
		LEFT JOIN dbo.VbecsUser VU ON VU.VbecsUserId = PBUT.TestTechId

	  WHERE 
	  
		PBUT.DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

		AND PS.PatientSpecimenGuid = @patientspecimenguid	

	-- Select matching product codes
	SELECT DISTINCT
		BU.BloodUnitGuid,
		BUS.BloodUnitStatusGuid,
		BU.UnitProductCode,
		DT.DonationTypeCode,
		BU.UnitDivisionId,
		BUM.BloodTypeCode,
		BUM.RhFactorCode,
		RHF.RhFactorText,		
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.UnitExpirationDate) AS UnitExpirationDate,
		PT.ProductTypeName,
		BP.ProductShortName,
		BUS.[RowVersion] as BloodUnitStatusRowVersion,
		BUSCC.UnitStatusCode,
		BU.LabelTypeCode

	FROM 
		dbo.BloodUnit BU

		JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitGuid = BU.BloodUnitGuid
		
		JOIN dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BU.BloodUnitGuid
		
		JOIN dbo.RhFactor RHF ON RHF.RhFactorCode = BUM.RhFactorCode

		JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid

		JOIN dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
		
		JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid
		
		JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BUSCC.BloodUnitGuid = BU.BloodUnitGuid
		
				JOIN dbo.OrderedUnit OU ON OU.OrderedUnitGuid = PBUT.OrderedUnitGuid

		LEFT JOIN dbo.OrderedTest ORT ON ORT.OrderedTestGuid = OU.OrderedTestGuid 

		LEFT JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGuid = OU.OrderedComponentGuid 

		JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = ORT.PatientSpecimenGuid
									OR PS.PatientSpecimenGuid = OC.PatientSpecimenGuid

		LEFT JOIN dbo.DonationType DT ON DT.DonationTypeId = BU.DonationTypeId

	WHERE 
		PBUT.DivisionCode = @divisioncode

		AND PBUT.PendingTestStatusId = @pendingteststatusid

		AND PS.PatientSpecimenGuid = @patientspecimenguid

		AND (OU.OrderedTestGuid = PBUT.OrderedTestGuid OR OU.OrderedComponentGuid = PBUT.OrderedComponentGuid)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInsertExceptionPatientAntigenDiscrepancy]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInsertExceptionPatientAntigenDiscrepancy]
GO

/****** Object:  StoredProcedure [dbo].[spInsertExceptionPatientAntigenDiscrepancy]    Script Date: 2/10/2016 4:48:53 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**
**	Desc: 	This inserts a Patient Antigen Discrepancy exception
**
**	Author: Krzysztof Dobranowski	
**
**	Date: 	04/05/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------	---------		------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	01/10/2005	D. Askew	Added @lastupdatedate
**	05/26/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					Minor changes made to error handling; verified NO COUNT is ON/OFF
**	06/28/2005 	D. Askew	Comments updated
**	08/11/2005 	S. Antropov	Updated column name reference: ExceptionDivision -> DivisionCode
**	09/02/2005	Lohse		Changed comments field length from 255 to 510
**	11/01/2005	K. Dobranowski	Changed @exceptiondivision to @divisioncode
**	01/23/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	02/10/2016	K. Dobranowski	Defect 251282 allowing null for @lotexpirationdate
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInsertExceptionPatientAntigenDiscrepancy]
(
	@exceptionpatientantigendiscrepancyguid	UNIQUEIDENTIFIER,
	@exceptiontypeid				INT,
	@patientguid					UNIQUEIDENTIFIER,
	@patientname					VARCHAR(60),
	@patientid					VARCHAR(30),
	@specimenuid					VARCHAR(15),
	@reagentname					VARCHAR(75),
	@reagenttypename				VARCHAR(25),
	@lotnumber					VARCHAR(15),
	@reagentmanufacturername			VARCHAR(50),
	@lotexpirationdate				DATETIME = NULL,
	@historicspecimentestresults			VARCHAR(55),
	@currentspecimentestresults			VARCHAR(55),
	@exceptioncomment				VARCHAR(510),
	@exceptionuser					VARCHAR(30),
	@exceptiondate					DATETIME,
	@testingtechname				VARCHAR(30),
	@divisioncode					CHAR(5),
	@lastupdateuser				VARCHAR (30),
	@lastupdatedate				DATETIME
)
 
AS

SET NOCOUNT ON

DECLARE @error	INT
DECLARE @rowcount	INT

	INSERT INTO	dbo.ExceptionPatientAntigenDiscrepancy
	(
			ExceptionPatientAntigenDiscrepancyGuid,
			ExceptionTypeId,
			PatientGuid,
			PatientName,
			PatientId,
			SpecimenUid,
			ReagentName,
			ReagentTypeName,
			LotNumber,
			ReagentManufacturerName,
			LotExpirationDate,
			HistoricSpecimenTestResults,
			CurrentSpecimenTestResults,
			ExceptionComment,
			ExceptionUser,
			ExceptionDate,
			TestingTechName,
			DivisionCode,
			LastUpdateUser,
			LastUpdateDate
	)
	VALUES
	(
			@exceptionpatientantigendiscrepancyguid,
			@exceptiontypeid,
			@patientguid,
			@patientname,
			@patientid,
			@specimenuid,
			@reagentname,
			@reagenttypename,
			@lotnumber,
			@reagentmanufacturername,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @lotexpirationdate),
			@historicspecimentestresults,
			@currentspecimentestresults,
			@exceptioncomment,
			@exceptionuser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @exceptiondate),
			@testingtechname,
			@divisioncode,
			@lastupdateuser,
			@lastupdatedate
	)
	
	SELECT @error = @@ERROR, @rowcount = @@ROWCOUNT

	IF @rowcount <> 1 RAISERROR( 50003, 16, 1, 'ExceptionPatientAntigenDiscrepancy', @rowcount )

SET NOCOUNT OFF

RETURN(@error)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetOrderedTestToPreviousTaskStatus]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetOrderedTestToPreviousTaskStatus]
GO

/****** Object:  StoredProcedure [dbo].[spGetOrderedTestToPreviousTaskStatus]    Script Date: 2/11/2016 9:16:03 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Get OrderedTest's Previous TaskStatus from the mirror (Defect 235354).
**
**	Author:	Doug Forst
**
**	Date: 	02/10/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	---------------	----------		-----------------
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetOrderedTestToPreviousTaskStatus]
(
	@orderedtestguid	UNIQUEIDENTIFIER
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON 

	SELECT TOP 1 TaskStatusCode
	FROM dbo.SynMirror_OrderedTest
	WHERE OrderedTestGuid = @orderedtestguid
	ORDER BY MirrorId DESC

SET @ERROR = @@ERROR
	
SET NOCOUNT OFF

RETURN (@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID]
GO

/****** Object:  StoredProcedure [dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID]    Script Date: 3/8/2016 3:39:17 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO






/*******************************************************************************************************************************************************************************
**	Desc:	Checks for available XM blood units for given SpecimenUID and Blood Unit ID (Defect 282082)
**
**	Author:	Doug Forst
**
**	Date: 	2/25/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name				Description
**	03/08/2016	Doug Forst			Defect 286187 - Added error checking
**	03/31/2016	R. Sankala			** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID]
(
	@specimenuid		VARCHAR(15),
	@eyereadableunitid	VARCHAR(13),
	@divisioncode		CHAR(5)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT  
		BUT.BloodUnitGuid, 
		BUS.BloodUnitStatusGuid,		
		BUT.UnitProductCode, 
		BP.ProductShortName,
		PT.ProductTypeName,
		PT.SortColumn AS ProductTypeSortColumn,
		BUT.OriginalVolume, 
		BUT.DiscardedPlasmaVolume, 
		dbo.fnGetPooledUnitsCount(BUT.BloodUnitGuid) AS PooledUnitsCount, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.UnitInDate) AS UnitInDate, 
		BUT.UnitFdaRegistrationNumber, 
		BUT.UnitContainerLotNumber, 
		BUT.DonationTypeID,
		DT.DonationTypeCode,
		BUT.UnitDivisionID, 
		BUT.LabelTypeCode, 
		BUT.LabelUnitID, 
		BUT.EyeReadableUnitID, 
		BUT.BloodProductGUID, 
		BUCS.IncomingShipmentGuid,
		BUT.DivisionCode, 
		BUT.EntryMethodCode, 
		BUT.ProcessingTechID,
		BUT.RecordStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) 	AS LastUpdateDate, 
		BUT.LastUpdateUser, 
		BUT.[RowVersion],
		dbo.fnIsUnitPendingTransfer(BUT.BloodUnitGuid) AS PendingTransferIndicator,
		BUM.BloodTypeCode, 
		BUM.RhFactorCode,
		RHF.RhFactorText,
		BUS.[RowVersion] as BloodUnitStatusRowVersion,
		BUSCC.UnitStatusCode

	FROM 
		dbo.OrderedUnit OU

		LEFT JOIN dbo.OrderedTest OT ON OT.OrderedTestGuid = OU.OrderedTestGuid

		LEFT JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGuid = OU.OrderedComponentGuid
		
		INNER JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = ISNULL(OT.PatientSpecimenGuid, OC.PatientSpecimenGuid)
		
		LEFT JOIN dbo.OrderableTest ORT ON ORT.OrderableTestId = OT.OrderableTestId

		INNER JOIN dbo.BloodUnit BUT ON BUT.BloodUnitGuid = OU.BloodUnitGuid

		INNER JOIN dbo.BloodUnitCurrentShipment BUCS ON BUCS.BloodUnitGuid = BUT.BloodUnitGuid

		INNER JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BUSCC.BloodUnitGuid = BUT.BloodUnitGuid

		INNER JOIN dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BUT.BloodUnitGuid

		INNER JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BUT.BloodUnitGuid

		INNER JOIN dbo.RhFactor RHF ON RHF.RhFactorCode = BUM.RhFactorCode

		INNER JOIN dbo.DonationType DT ON DT.DonationTypeID = BUT.DonationTypeID

		INNER JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BUT.BloodProductGuid

		INNER JOIN dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode

	WHERE  
		PS.SpecimenUid = @specimenuid 
		AND ISNULL(OT.OrderStatusCode,'A')  = 'A' 
		AND (ISNULL(OT.TaskStatusCode,'N') = 'N' OR ISNULL(OT.TaskStatusCode,'R') = 'R' OR ISNULL(OT.TaskStatusCode,'E') = 'E') 
		AND (ISNULL(OC.OrderStatusCode,'A') = 'A' OR ISNULL(OC.TaskStatusCode,'E') = 'E')
		AND OU.CrossmatchDate IS NULL
		AND OU.ReleaseDate IS NULL
		AND OU.CrossmatchRequiredIndicator = 1
		AND BUT.EyeReadableUnitId = @eyereadableunitid
		AND OU.DivisionCode = @divisioncode
		AND	BUT.RecordStatusCode = 'A'

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)





GO



--Permissions
GRANT EXECUTE ON  [dbo].[spHL7InsertPendingSpecimenTest] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7InsertPendingBloodUnitTest] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPendingBloodUnitTests] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodUnitsByUnitId] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPendingBloodUnitTestsCount] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPendingSpecimenTestsCount] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spUpdatePendingBloodUnitTest] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPatientsWithPendingSpecimenTests] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7GetVbecsUserWithVariableLengthID] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAboRHConfirmationTestsForUnit] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAntigenTypingTestsForUnit] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodUnitTestingWorklist] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInactivateAboRHConfirmationTests] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInactivateAntigenTypingTests] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPendingSpecimenTests] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7GetBloodTestTypeMapping] TO [VbecsAppUser]
GO 

GRANT EXECUTE ON  [dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName] TO [VbecsAppUser]
GO 

GRANT EXECUTE ON  [dbo].[spHL7GetPendingSpecimenTest] TO [VbecsAppUser]
GO 

GRANT EXECUTE ON  [dbo].[spUpdatePendingSpecimenTest] TO [VbecsAppUser]
GO 

GRANT EXECUTE ON  [dbo].[spUpdateOrderedTestToPreviousTaskStatus] TO [VbecsAppUser]
GO 

GRANT EXECUTE ON  [dbo].[spHL7GetPendingBloodUnitTest] TO [VbecsAppUser]
GO 

GRANT EXECUTE ON  [dbo].[spGetPoolCounter] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInsertVbecsLock] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetTestingTaskList] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetDivisionWorkloadReport] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAuditUser] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAuditUserRole] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetOrderedUnitsForUnit] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodUnitTestResultsForOrderedComponent] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodUnitTestResultsForOrderedTest] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPatientTestingWorklist] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPatientTestingWorklistByDates] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetSpecimenTestResultsForOrderedTest] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[batchspRunExpireTestOrders] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spIsPendingBloodUnitTestLocked] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spIsPendingSpecimenTestLocked] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7GetXMBySpecimenUIDAndUnitID] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetLimitedBloodUnit] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetLimitedBloodUnitsByDivision] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetPendingBloodUnitXMTests] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInsertExceptionPatientAntigenDiscrepancy] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetOrderedTestToPreviousTaskStatus] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID] TO [VbecsAppUser]
GO

EXEC sp_msForEachTable @COMMAND1 = 'ALTER INDEX ALL ON ? REBUILD WITH (ONLINE=OFF)'

		

USE @DBNAME@
GO

/*****************************************************
**	Update VbecsVersion
*****************************************************/

DECLARE @SUser	VARCHAR(45)

SET @SUser = SUSER_SNAME()

INSERT INTO dbo.VbecsVersion
(Version, PatchSuccessfulIndicator, LastUpdateDate, LastUpdateUser)
VALUES('2.2.0.2',0, GETUTCDATE(), RIGHT(@SUser, LEN(@SUser) - CHARINDEX('\', @SUser)))


/*****************************************************
**	Update VbecsDBRevision
*****************************************************/

INSERT INTO dbo.VbecsDBRevision
(VbecsVersion, Revision, Comment, LastUpdateDate, LastUpdateUser)
VALUES('2.2.0.2','A', '', GETUTCDATE(), RIGHT(@SUser, LEN(@SUser) - CHARINDEX('\', @SUser)))



